<?php


function dzsvg_shortcode_showcase_builder() {

  global $dzsvg;

  $url_admin = get_admin_url();
//<script src="<?php echo site_url(); "></script>

  $taxonomy_main = 'dzsvideo_category';


  $categories = get_terms($taxonomy_main, 'orderby=count&hide_empty=0');


//    print_r($categories);


  $cats_checkboxes = '';
  $cats_options = '<option value="none">' . __("None") . '</option>';

  if (count($categories) > 0) {
    foreach ($categories as $cat) {
//            print_r($cat);
      $cats_checkboxes .= '<label for="cat' . $cat->term_id . '"><input type="checkbox" name="cat_checkbox[]" id="cat' . $cat->term_id . '" value="' . $cat->term_id . '"><span class="the-label"><span class="the-text"> ' . $cat->name . '</span></span></label> ';

      $cats_options .= '<option value="' . $cat->term_id . '">' . $cat->name . '</option>';
    }
  }

  ?>
  <div class="sc-con sc-con-for-showcase-builder">

  <script>
    <?php

    $terms = get_terms($taxonomy_main, 'orderby=count&hide_empty=0');
    ?>
    window.dzsvg_showcase_options = {
      'sampledata_installed': <?php if (get_option('dzsvg_demo_data') == '') {
        echo 'false';
      } else {
        echo 'true';
      }; ?>
      ,
      'sampledata_cats': ["<?php $demo_data = (get_option('dzsvg_demo_data')); $i = 0; if (isset($demo_data['cats']) && is_array($demo_data['cats'])) {
        foreach ($demo_data['cats'] as $cat) {
          if ($i > 0) {
            echo "\",\"";
          }
          echo $cat;
          ++$i;
        }
      }; ?>"]
      ,
      'categoryportfolio_terms': "<?php $i = 0; foreach ($terms as $term) {
        if ($i > 0) {
          echo ',';
        }
        echo $term->term_id;
        ++$i;
      }; echo ';'; $i = 0; foreach ($terms as $term) {
        if ($i > 0) {
          echo ',';
        }
        echo $term->name;
        ++$i;
      }; ?>"
    };
  </script>
  <div class="sc-menu">


    <div class="main-type-container">


      <div class="setting  mode-any">
        <h3><?php echo __("Type"); ?></h3>
        <?php


        $lab = "type";


        $arr_opts = array(
          'video_items',
          'youtube',
          'vimeo',
          'video_gallery',
          'facebook',
        );


        echo DZSHelpers::generate_select($lab, array(
          'options' => $arr_opts,
          'class' => 'dzs-style-me opener-listbuttons dzs-dependency-field',
          'seekval' => '',
        ));

        ?>
        <ul class="dzs-style-me-feeder">
          <li><span class="option-con"><img src="<?php echo DZSVG_URL; ?>tinymce/img/type1.png"/><span
                class="option-label"><?php echo __("Video Items"); ?></span></span></li>
          <li><span class="option-con"><img src="<?php echo DZSVG_URL; ?>tinymce/img/type2.png"/><span
                class="option-label"><?php echo __("YouTube Feed"); ?></span></span></li>
          <li><span class="option-con"><img src="<?php echo DZSVG_URL; ?>tinymce/img/type3.png"/><span
                class="option-label"><?php echo __("Vimeo Feed"); ?></span></span></li>
          <li><span class="option-con"><img
                src="<?php echo DZSVG_URL; ?>tinymce/img/type_video_gallery.png"/><span
                class="option-label"><?php echo __("Video Gallery"); ?></span></span></li>
          <li><span class="option-con"><img src="<?php echo DZSVG_URL; ?>tinymce/img/type_facebook.png"/><span
                class="option-label"><?php echo __("Facebook"); ?></span></span></li>
        </ul>
        <div class="sidenote"><?php echo __("This is where the showcase items will come from... "); ?></div>
      </div>


      <!--            <div class="setting type-any ">-->
      <!--                <h3>--><?php //echo __("Type");
      ?><!--</h3>-->
      <!--                --><?php
      //
      //
      //                $lab = "type";
      //
      //
      //                $arr_opts = array(
      //                    array(
      //                        'lab'=>__('Latest Videos'),
      //                        'val'=>'latest',
      //                    ),
      //                    array(
      //                        'lab'=>__('Most Viewed'),
      //                        'val'=>'mostviewed',
      //                    ),
      //                    array(
      //                        'lab'=>__('Most Liked'),
      //                        'val'=>'mostliked',
      //                    ),
      //                    array(
      //                        'lab'=>__("Playlist"),
      //                        'val'=>'mostliked',
      //                    ),
      //                );
      //
      //
      //                echo DZSHelpers::generate_select($lab, array(
      //                    'options'=>$arr_opts,
      //                    'class'=>'dzs-style-me skin-beige',
      //                ));
      //
      //
      ?>
      <!--            </div>-->

      <?php

      // -- for future we can do a logical set like "(" .. ")" .. "AND" .. "OR"
      $dependency = array(

        array(
          'lab' => 'type',
          'val' => array('video_gallery'),
        ),
      );


      ?>


      <div class="setting type-any" data-dependency='<?php echo json_encode($dependency); ?>'>
        <h3><?php echo esc_html__("Select a Gallery to Insert", DZSVG_ID); ?></h3>
        <select class="styleme dzs-dependency-field" name="dzsvg_selectid">
          <?php

          //          include_once('../class_parts/class-helper.php');

          echo DZSVideoGalleryHelper::get_string_galleries_to_select_options();
          //          foreach ($dzsvg->mainitems as $mainitem) {
          //            echo '<option>' . ($mainitem['settings']['id']) . '</option>';
          //          }
          ?>
        </select>
      </div>


      <?php


      $lab = 'cat';
      echo DZSHelpers::generate_input_text($lab, array(
        'class' => '  dzs-dependency-field',
        'seekval' => '',
        'input_type' => 'hidden',
      ));
      ?>


      <?php if ($cats_checkboxes) { ?>
        <div class="setting type-video_items ">
          <h3><?php echo __("Category"); ?></h3>
          <?php echo '<div class="dzs-checkbox-selector skin-nova">';


          echo $cats_checkboxes;

          echo '</div>';
          ?>
        </div>
      <?php } ?>


      <div class="setting type-youtube ">
        <h3><?php echo __("Link"); ?></h3>
        <input class="regular-text  dzs-dependency-field" name="youtube_link" value=""/>
        <div
          class="sidenote"><?php printf(__('ie. %1$s - for a user channel feed') . '<br>', '<strong>https://www.youtube.com/user/digitalzoomstudio</strong>');
          printf(__('ie. %1$s - for a playlist feed') . '<br>', '<strong>https://www.youtube.com/playlist?list=PLBsCKuJJu1pbD4ONNTHgNsVebK4ughuch</strong>');
          printf(__('ie. %1$s - for a search feed') . '<br>', '<strong>https://www.youtube.com/results?search_query=cat+funny</strong>'); ?></div>
      </div>

      <div class="setting type-youtube ">
        <h3><?php echo __("Max. Videos"); ?></h3>
        <input class="regular-text" name="max_videos" value=""/>
      </div>


      <div class="setting type-facebook ">
        <h3><?php echo __("Link"); ?></h3>
        <input class="regular-text  dzs-dependency-field" name="facebook_link" value=""/>
        <div
          class="sidenote"><?php printf(__('ie. %1$s - for a page public videos') . '<br>', '<strong>https://facebook.com/digitalzoomstudio</strong>');;; ?></div>
      </div>

      <div class="setting type-vimeo ">
        <h3><?php echo __("Link"); ?></h3>
        <input class="regular-text  dzs-dependency-field" name="vimeo_link" value=""/>
        <div
          class="sidenote"><?php printf(__('ie. %1$s - for a user channel feed') . '<br>', '<strong>https://vimeo.com/user5137664</strong>');
          printf(__('ie. %1$s - for a channel feed') . '<br>', '<strong>https://vimeo.com/channels/636900</strong>');
          printf(__('ie. %1$s - for a album feed') . '<br>', '<strong>https://vimeo.com/album/2633720</strong>'); ?></div>
      </div>


      <div class="setting  type-video_items">
        <h3><?php echo __("Order By"); ?></h3>
        <?php


        $lab = "orderby";


        $arr_opts = array(
          array(
            'value' => 'none',
            'label' => __("Default"),
          ),
          array(
            'value' => 'date',
            'label' => __("Date"),
          ),
          array(
            'value' => 'views',
            'label' => __("Views"),
          ),
          array(
            'value' => 'similar',
            'label' => __("Similar"),
          ),
        );


        echo DZSHelpers::generate_select($lab, array(
          'options' => $arr_opts,
          'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
          'seekval' => '',
        ));
        ?>
      </div>

      <div class="setting  type-video_items">
        <h3><?php echo __("Order"); ?></h3>
        <?php


        $lab = "order";


        $arr_opts = array(
          array(
            'value' => 'DESC',
            'label' => __("Descending"),
          ),
          array(
            'value' => 'ASC',
            'label' => __("Ascending"),
          ),
        );


        echo DZSHelpers::generate_select($lab, array(
          'options' => $arr_opts,
          'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
          'seekval' => '',
        ));
        ?>
      </div>


      <!-- end type-container-->
    </div>
    <div class="setting  mode-any">
      <h3><?php echo __("Mode"); ?></h3>
      <?php


      $lab = "mode";


      $arr_opts = array(
        'ullist',
        'list',
        'list-2',
        'featured',
        'scroller',
        'scrollmenu',
        'zfolio',
        'gallery_view',
      );


      echo DZSHelpers::generate_select($lab, array(
        'options' => $arr_opts,
        'class' => 'dzs-style-me opener-listbuttons  dzs-dependency-field',
        'seekval' => '',
      ));

      ?>
      <ul class="dzs-style-me-feeder">
        <li><span class="option-con"><img src="<?php echo DZSVG_URL; ?>assets/svg/style_ullist.svg"/><span
              class="option-label"><?php echo __("UL LIST"); ?></span></span></li>
        <li><span class="option-con"><img src="<?php echo DZSVG_URL; ?>assets/svg/style_list.svg"/><span
              class="option-label"><?php echo __("LIST"); ?></span></span></li>
        <li><span class="option-con"><img src="<?php echo DZSVG_URL; ?>assets/svg/style_list-2.svg"/><span
              class="option-label"><?php echo __("LIST"); ?> 2</span></span></li>
        <li><span class="option-con"><img src="<?php echo DZSVG_URL; ?>assets/svg/style_featured.svg"/><span
              class="option-label"><?php echo __("FEATURED"); ?></span></span></li>
        <li><span class="option-con"><img src="<?php echo DZSVG_URL; ?>assets/svg/style_scroller.svg"/><span
              class="option-label"><?php echo __("SCROLLER"); ?></span></span></li>
        <li><span class="option-con"><img src="<?php echo DZSVG_URL; ?>assets/svg/scrollmenu.svg"/><span
              class="option-label"><?php echo __("SCROLL MENU"); ?></span></span></li>
        <li><span class="option-con"><img src="<?php echo DZSVG_URL; ?>assets/svg/style_zfolio.svg"/><span
              class="option-label"><?php echo __("ZFOLIO"); ?></span></span></li>
        <li><span class="option-con"><img src="<?php echo DZSVG_URL; ?>assets/svg/style_gallery_view.svg"/><span
              class="option-label"><?php echo __("GALLERY VIEW"); ?></span></span></li>
      </ul>
    </div>

    <div class="setting  mode-scrollmenu">
      <h4><?php echo __("Scroll Menu Height"); ?></h4>
      <input class="regular-text" name="mode_scrollmenu_height" value="300"/>


    </div>


    <div class="setting  mode-zfolio">
      <h3><?php echo __("Skin"); ?></h3>
      <?php


      $lab = "mode_zfolio_skin";


      $arr_opts = array(
        array(
          'value' => 'skin-forwall',
          'label' => esc_html__("Skin Forwall", 'dzsvg'),
        ),
        array(
          'value' => 'skin-alba',
          'label' => esc_html__("Skin Alba", 'dzsvg'),
        ),
        array(
          'value' => 'skin-overlay',
          'label' => esc_html__("Skin Overlay", 'dzsvg'),
        ),
      );


      echo DZSHelpers::generate_select($lab, array(
        'options' => $arr_opts,
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>
    </div>

    <div class="setting  mode-zfolio">
      <h3><?php echo __("Gap Size"); ?></h3>
      <?php


      $lab = "mode_zfolio_gap";


      $arr_opts = array(
        array(
          'value' => '30px',
          'label' => __("30px"),
        ),
        array(
          'value' => '1px',
          'label' => __("1px"),
        ),
      );


      echo DZSHelpers::generate_select($lab, array(
        'options' => $arr_opts,
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>
    </div>

    <div class="setting  mode-zfolio">
      <h3><?php echo __("Layout"); ?></h3>
      <?php


      $lab = "mode_zfolio_layout";


      $arr_opts = array(
        array(
          'value' => '3columns',
          'label' => sprintf(esc_html__("%s Columns "), '3'),
        ),
        array(
          'value' => '5columns',
          'label' => __("5 Columns"),
        ),
      );


      echo DZSHelpers::generate_select($lab, array(
        'options' => $arr_opts,
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>
    </div>

    <div class="setting  mode-zfolio">
      <h3><?php echo __("Title links to..."); ?></h3>
      <?php


      $lab = "mode_zfolio_title_links_to";


      $arr_opts = array(
        array(
          'value' => '',
          'label' => __("Nothing"),
        ),

        array(
          'value' => 'direct_link_a',
          'label' => __("Direct Link"),
        ),
        array(
          'value' => 'zoombox',
          'label' => __("Lightbox open"),
        ),
      );


      echo DZSHelpers::generate_select($lab, array(
        'options' => $arr_opts,
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>
    </div>

    <div class="setting  mode-gallery_view">
      <h3><?php echo esc_html__("Navigation Type", 'dzsvg'); ?></h3>
      <?php


      $lab = "mode_gallery_view_nav_type";


      $arr_opts = array(
        array(
          'value' => 'thumbs',
          'label' => __("Normal"),
        ),
        array(
          'value' => 'thumbsandarrows',
          'label' => __("Thumbnails and Arrows"),
        ),
        array(
          'value' => 'scroller',
          'label' => __("Scrollbar"),
        ),
      );


      echo DZSHelpers::generate_select($lab, array(
        'options' => $arr_opts,
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>
    </div>

    <div class="setting  mode-gallery_view">
      <h3><?php echo esc_html__("Gallery Skin", 'dzsvg'); ?></h3>
      <?php


      $lab = 'mode_gallery_view_gallery_skin';
      $arr_opts = array(
        array(
          'value' => 'skin_default',
          'label' => esc_html__("Default", 'dzsvg'),
        ),
        array(
          'value' => 'skin_navtransparent',
          'label' => __("Navigation Transparent"),
        ),
        array(
          'value' => 'skin_pro',
          'label' => __("Skin Pro"),
        ),
        array(
          'value' => 'skin_boxy',
          'label' => __("Skin Boxy"),
        ),
        array(
          'value' => 'skin_custom',
          'label' => __("Skin Custom"),
        ),
      );


      echo DZSHelpers::generate_select($lab, array(
        'options' => $arr_opts,
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>

      <div class="sidenote"><?php echo __('Skin Custom can be modified via Designer Center.', 'dzsvg'); ?></div>
    </div>

    <div class="setting  mode-gallery_view">
      <h3><?php echo __("Gallery Skin"); ?></h3>
      <?php

      $lab = 'mode_gallery_view_set_responsive_ratio_to_detect';

      $arr_off_on = array(
        array(
          'value' => 'off',
          'label' => __("Off"),
        ),
        array(
          'value' => 'on',
          'label' => __("On"),
        ),
      );


      echo DZSHelpers::generate_select($lab, array(
        'options' => $arr_off_on,
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>

      <div
        class="sidenote"><?php echo __('The player can adjust to keep aspect ratio / no black bars', 'dzsvg'); ?></div>
    </div>

    <div class="setting  mode-gallery_view">
      <h3><?php echo __("Autoplay"); ?></h3>
      <?php

      $lab = 'mode_gallery_view_autoplay';


      echo DZSHelpers::generate_select($lab, array(
        'options' => $arr_off_on,
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>

      <div class="sidenote"><?php echo __('auto play the first video', 'dzsvg'); ?></div>
    </div>

    <div class="setting  mode-gallery_view">
      <h3><?php echo __("Autoplay Next Video"); ?></h3>
      <?php

      $lab = 'mode_gallery_view_autoplaynext';


      echo DZSHelpers::generate_select($lab, array(
        'options' => $arr_off_on,
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>

      <div class="sidenote"><?php echo __('auto play the first video', 'dzsvg'); ?></div>
    </div>

    <div class="setting  mode-gallery_view">
      <h3><?php echo __("Autoload First Video"); ?></h3>
      <?php

      $lab = 'mode_gallery_view_cueFirstVideo';


      echo DZSHelpers::generate_select($lab, array(
        'options' => $arr_off_on,
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>

      <div class="sidenote"><?php echo __('auto load the first video', 'dzsvg'); ?></div>
    </div>

    <div class="setting  mode-gallery_view">
      <h3><?php echo __("Enable Analytics"); ?></h3>
      <?php

      $lab = 'mode_gallery_view_analytics_enable';


      echo DZSHelpers::generate_select($lab, array(
        'options' => $arr_off_on,
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>

      <div class="sidenote"><?php echo __('', 'dzsvg'); ?></div>
    </div>

    <div class="setting  mode-gallery_view">
      <h3><?php echo __("Force Width"); ?></h3>
      <?php

      $lab = 'mode_gallery_view_width';


      echo DZSHelpers::generate_input_text($lab, array(
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>

      <div class="sidenote"><?php echo __('input a width - ie. "900" ( pixels ) or "100%" ', 'dzsvg'); ?></div>
    </div>

    <div class="setting  mode-gallery_view">
      <h3><?php echo __("Force Height"); ?></h3>
      <?php

      $lab = 'mode_gallery_view_height';


      echo DZSHelpers::generate_input_text($lab, array(
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>

      <div
        class="sidenote"><?php echo __('input a height - ie. "900" ( pixels ) or "100%" - this will get overwritten if responsive ratio is set ', 'dzsvg'); ?></div>
    </div>


    <div class="setting  mode-gallery_view">
      <h3><?php echo __("Navigation Type"); ?></h3>
      <?php

      $lab = 'mode_gallery_view_nav_type';

      $arr_positions = array(
        array(
          'value' => 'thumbs',
          'label' => __("Thumbnails"),
        ),
        array(
          'value' => 'thumbsandarrows',
          'label' => __("Thumbnails and Arrows"),
        ),
        array(
          'value' => 'scroller',
          'label' => __("Scroller"),
        ),
        array(
          'value' => 'outer',
          'label' => __("Top"),
        ),
        array(
          'value' => 'none',
          'label' => __("None"),
        ),
      );


      echo DZSHelpers::generate_select($lab, array(
        'options' => $arr_positions,
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>

      <div class="sidenote"><?php echo __('choose the navigation between items type', 'dzsvg'); ?></div>
    </div>


    <div class="setting  mode-gallery_view">
      <h3><?php echo __("Menu Item Width"); ?></h3>
      <?php

      $lab = 'mode_gallery_view_html5designmiw';


      echo DZSHelpers::generate_input_text($lab, array(
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'val' => '275',
      ));
      ?>

      <div
        class="sidenote"><?php echo __('input a width - ie. "200" ( pixels ) or "100%" - this will get overwritten if responsive ratio is set ', 'dzsvg'); ?></div>
    </div>

    <div class="setting  mode-gallery_view">
      <h3><?php echo __("Menu Item Height"); ?></h3>
      <?php

      $lab = 'mode_gallery_view_html5designmih';


      echo DZSHelpers::generate_input_text($lab, array(
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'val' => '100',
      ));
      ?>

      <div
        class="sidenote"><?php echo __('input a height - ie. "200" ( pixels ) or "100%" - this will get overwritten if responsive ratio is set ', 'dzsvg'); ?></div>
    </div>

    <div class="setting  mode-gallery_view">
      <h3><?php echo __("Navigation Space"); ?></h3>
      <?php

      $lab = 'mode_gallery_view_nav_space';


      echo DZSHelpers::generate_input_text($lab, array(
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'val' => '0',
      ));
      ?>

      <div class="sidenote"><?php echo __('navigation space between video and navigation', 'dzsvg'); ?></div>
    </div>


    <div class="setting  mode-gallery_view">
      <h3><?php echo __("Menu Position"); ?></h3>
      <?php

      $lab = 'mode_gallery_view_menuposition';

      $arr_positions = array(
        array(
          'value' => 'right',
          'label' => __("Right"),
        ),
        array(
          'value' => 'bottom',
          'label' => __("Bottom"),
        ),
        array(
          'value' => 'left',
          'label' => __("Left"),
        ),
        array(
          'value' => 'top',
          'label' => __("Top"),
        ),
        array(
          'value' => 'none',
          'label' => __("None"),
        ),
      );


      echo DZSHelpers::generate_select($lab, array(
        'options' => $arr_positions,
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>

      <div
        class="sidenote"><?php echo __('Only available for the thumbnails / thumbnails and arrows / scroller navigation type', 'dzsvg'); ?></div>
    </div>


    <div class="setting  mode-gallery_view">
      <h3><?php echo __("Play order"); ?></h3>
      <?php

      $lab = 'mode_gallery_view_playorder';

      $arr_positions = array(
        array(
          'value' => 'normal',
          'label' => __("Normal"),
        ),
        array(
          'value' => 'reverse',
          'label' => __("Reverse"),
        ),
      );


      echo DZSHelpers::generate_select($lab, array(
        'options' => $arr_positions,
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>

      <div class="sidenote"><?php echo __('', 'dzsvg'); ?></div>
    </div>


    <div class="setting  mode-gallery_view">
      <h3><?php echo __("Disable Video Title"); ?></h3>
      <?php

      $lab = 'mode_gallery_view_disable_video_title';


      echo DZSHelpers::generate_select($lab, array(
        'options' => $arr_off_on,
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>

      <div class="sidenote"><?php echo __('hide the video title', 'dzsvg'); ?></div>
    </div>


    <div class="setting  mode-gallery_view">
      <h3><?php echo __("Enable Easing on Navigation Thumbnails"); ?></h3>
      <?php

      $lab = 'mode_gallery_view_design_navigationuseeasing';


      echo DZSHelpers::generate_select($lab, array(
        'options' => $arr_off_on,
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>

      <div class="sidenote"><?php echo __('', 'dzsvg'); ?></div>
    </div>


    <div class="setting  mode-gallery_view">
      <h3><?php echo __("Enable Search Field"); ?></h3>
      <?php

      $lab = 'mode_gallery_view_enable_search_field';


      echo DZSHelpers::generate_select($lab, array(
        'options' => $arr_off_on,
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>

      <div class="sidenote"><?php echo __('', 'dzsvg'); ?></div>
    </div>


    <div class="setting  mode-gallery_view">
      <h3><?php echo __("Enable Linking"); ?></h3>
      <?php

      $lab = 'mode_gallery_view_settings_enable_linking';


      echo DZSHelpers::generate_select($lab, array(
        'options' => $arr_off_on,
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>

      <div
        class="sidenote"><?php echo __('enable so that each video has it\'s own link and can be shared.', 'dzsvg'); ?></div>
    </div>


    <div class="setting  mode-gallery_view">
      <h3><?php echo __("Autoplay Advertisment"); ?></h3>
      <?php

      $lab = 'mode_gallery_view_autoplay_ad';


      echo DZSHelpers::generate_select($lab, array(
        'options' => $arr_off_on,
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>

      <div class="sidenote"><?php echo __('autoplay adverts', 'dzsvg'); ?></div>
    </div>


    <div class="setting  mode-gallery_view">
      <h3><?php echo __("Enable Embed Button"); ?></h3>
      <?php

      $lab = 'mode_gallery_view_embedbutton';


      echo DZSHelpers::generate_select($lab, array(
        'options' => $arr_off_on,
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>

      <div class="sidenote"><?php echo __('', 'dzsvg'); ?></div>
    </div>


    <div class="setting  mode-gallery_view">
      <h3><?php echo __("Logo"); ?></h3>
      <?php

      $lab = 'mode_gallery_view_logo';


      echo DZSHelpers::generate_input_text($lab, array(
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>

      <div class="sidenote"><?php echo __('', 'dzsvg'); ?></div>
    </div>


    <div class="setting  mode-gallery_view">
      <h3><?php echo __("Logo Link"); ?></h3>
      <?php

      $lab = 'mode_gallery_view_logoLink';


      echo DZSHelpers::generate_input_text($lab, array(
        'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
        'seekval' => '',
      ));
      ?>

      <div class="sidenote"><?php echo __('', 'dzsvg'); ?></div>
    </div>


    <div class="setting  mode-zfolio">
      <h3><?php echo __("Enable Special Layout"); ?></h3>
      <?php


      $lab = "mode_zfolio_enable_special_layout";


      ?>
      <div class="dzscheckbox skin-nova"><?php
        echo DZSHelpers::generate_input_checkbox($lab, array(
          'id' => $lab,
          'val' => 'on',
          'class' => ' dzs-dependency-field',));
        ?>
        <label for="<?php echo $lab; ?>"></label>
      </div>
    </div>


    <div class="setting  mode-zfolio">
      <h3><?php echo __("Show Filters"); ?></h3>
      <?php


      $lab = "mode_zfolio_show_filters";


      ?>
      <div class="dzscheckbox skin-nova"><?php
        echo DZSHelpers::generate_input_checkbox($lab, array(
          'id' => $lab,
          'val' => 'on',
          'class' => ' dzs-dependency-field',));
        ?>
        <label for="<?php echo $lab; ?>"></label>
      </div>
    </div>


    <?php

    $dependency = array(

      array(
        'lab' => 'mode_zfolio_show_filters',
        'val' => array('on'),
      ),
    );


    ?>


    <div class="setting type-any" data-dependency='<?php echo json_encode($dependency); ?>'>

      <h3><?php echo __("Categories are links"); ?></h3>
      <?php


      $lab = "mode_zfolio_categories_are_links";


      ?>
      <div class="dzscheckbox skin-nova"><?php
        echo DZSHelpers::generate_input_checkbox($lab, array(
          'id' => $lab,
          'val' => 'on',
          'class' => ' dzs-dependency-field',));
        ?>
        <label for="<?php echo $lab; ?>"></label>
      </div>


    </div>


    <div class="setting type-any" data-dependency='<?php echo json_encode($dependency); ?>'>

      <h3><?php echo __("Categories are ajax links"); ?></h3>
      <?php


      $lab = "mode_zfolio_categories_are_links_ajax";


      ?>
      <div class="dzscheckbox skin-nova"><?php
        echo DZSHelpers::generate_input_checkbox($lab, array(
          'id' => $lab,
          'val' => 'on',
          'class' => ' dzs-dependency-field',));
        ?>
        <label for="<?php echo $lab; ?>"></label>


      </div>

      <div
        class="sidenote"><?php echo __("Enable this for instant ajax functionality  when switching categories - and updating link"); ?></div>


    </div>


    <div class="setting type-any" data-dependency='<?php echo json_encode($dependency); ?>'>

      <h3><?php echo __("Default Category"); ?></h3>
      <?php


      $lab = "mode_zfolio_default_cat";


      ?><select name="<?php echo $lab; ?>" class="dzs-style-me skin-beige"><?php echo $cats_options; ?></select>


    </div>

    <div class="setting  mode-list">
      <h3><?php echo __("Enable View Count"); ?></h3>
      <?php


      $lab = "mode_list_enable_view_count";


      ?>
      <div class="dzscheckbox skin-nova"><?php
        echo DZSHelpers::generate_input_checkbox($lab, array(
          'id' => $lab,
          'val' => 'on',
          'class' => ' dzs-dependency-field ',));
        ?>
        <label for="<?php echo $lab; ?>"></label>
      </div>
    </div>


    <br>


    <link href='https://fonts.googleapis.com/css?family=Open+Sans:700' rel='stylesheet' type='text/css'>
    <style id="dzstabs_accordio_styling"></style>
    <div id="dzstabs_accordio" class="dzs-tabs auto-init skin-melbourne tab-menu-content-con---no-padding"
         data-options="{ 'design_tabsposition' : 'top'
,design_transition: 'fade'
,design_tabswidth: 'default'
,toggle_breakpoint : '300'
,refresh_tab_height: '2000'
,settings_appendWholeContent: true
,design_tabswidth: 'fullwidth'
,toggle_type: 'accordion'}">

      <div class="dzs-tab-tobe">
        <div class="tab-menu "><?php echo esc_html__("Linking Settings", 'dzsvg'); ?></div>
        <div class="tab-content">

          <div class="sidenote"
               style="font-size:14px;"><?php echo esc_html__('Choose what clicking on the video item does', 'dzsvg'); ?></div>

          <div class="linking_type-con">
            <div class="setting  linking_type-all">
              <h3><?php echo __("Link Type"); ?></h3>
              <?php


              $lab = "linking_type";


              $arr_opts = array(
                array(
                  'value' => 'default',
                  'label' => __("Default"),
                ),
                array(
                  'value' => 'zoombox',
                  'label' => __("Zoombox"),
                ),
                array(
                  'value' => 'direct_link',
                  'label' => __("Direct Link to item page"),
                ),
                array(
                  'value' => 'vg_change',
                  'label' => __("Change Video Player"),
                ),
              );


              echo DZSHelpers::generate_select($lab, array(
                'options' => $arr_opts,
                'class' => 'dzs-style-me skin-beige  dzs-dependency-field',
                'seekval' => '',
              ));
              ?>
              <div class="sidenote"
                   style=";"><?php echo __('<strong>Default</strong> - means that the item click action will depend on the mode you chose and choose its default mode.  <br><strong>Zoombox</strong> - open the video in a lightbox. <br><strong>Direct Link</strong> - clicking will get the user to the video page.  <br><strong>Change Video Player</strong> - clicking will change a player current video.  ', 'dzsvg'); ?></div>
            </div>


            <div class="setting  linking_type-vg_change">
              <h3><?php echo __("ID of Target Gallery"); ?></h3>
              <input name="gallery_target" value="default"/>

              <div class="sidenote" style=";"><?php echo __('', 'dzsvg'); ?></div>
            </div>


          </div>

          <br>
          <br>


        </div>
      </div>

      <div class="dzs-tab-tobe">
        <div class="tab-menu "><?php echo __("Video Player Settings"); ?></div>
        <div class="tab-content">

          <?php


          $vpconfigsstr = '';
          foreach ($dzsvg->mainvpconfigs as $vpconfig) {
            //print_r($vpconfig);
            $vpconfigsstr .= '<option value="' . $vpconfig['settings']['id'] . '">' . $vpconfig['settings']['id'] . '</option>';
          }

          ?>

          <div class="sidenote"
               style="font-size:14px;"><?php echo __('Choose what clicking on the video item does', 'dzsvg'); ?></div>

          <div class="setting mode-any">
            <h3 class="setting-label"><?php echo __('Video Player Configuration', 'dzsvg'); ?></h3>
            <select class=" dzs-style-me skin-beige  dzs-dependency-field" name="vpconfig">
              <option value="default"><?php echo __('default', 'dzsvg'); ?></option>
              <?php echo $vpconfigsstr; ?>
            </select>
            <div class="sidenote"
                 style=""><?php echo __('setup these inside the <strong>Video Player Configs</strong> admin', 'dzsvg'); ?></div>
          </div>


          <br>
          <br>


        </div>
      </div>


      <div class="dzs-tab-tobe">
        <div class="tab-menu "><?php echo __("Description Settings"); ?></div>
        <div class="tab-content">

          <div class="sidenote"
               style="font-size:14px;"><?php echo __('Use these settings to control how many characters get shown from the video content.', 'dzsvg'); ?></div>

          <div class="setting  mode-any">
            <h3><?php echo __("Number of Characters"); ?></h3>
            <input name="desc_count" value="default"/>

            <div class="sidenote"
                 style=";"><?php echo __('Leave this to <strong>default</strong> in order for the number of characters to get best displayed based on the Mode.. ', 'dzsvg'); ?></div>
          </div>

          <br>
          <br>


        </div>
      </div>

      <div class="dzs-tab-tobe ">
        <div class="tab-menu ">
          <?php echo __("Pagination Settings"); ?>
        </div>
        <div class="tab-content">
          <div class="sidenote"
               style="font-size:14px;"><?php echo __('Useful if you have many videos and you want to separate them somehow.', 'dzsvg'); ?></div>

          <!--                <div class="setting  mode-any">-->
          <!--                    <h3>--><?php //echo __("Select a Pagination Method");
          ?><!--</h3>-->
          <!--                    <select class="styleme" name="dzsvg_settings_separation_mode">-->
          <!--                        <option>normal</option>-->
          <!--                        <option>pages</option>-->
          <!--                        <option>scroll</option>-->
          <!--                        <option>button</option>-->
          <!--                    </select>-->
          <!---->
          <!--                </div>-->
          <div class="setting  mode-any">
            <h3><?php echo __("Select Number of Items per Page"); ?></h3>
            <input name="count" value="5"/>


          </div>
          <br>
          <br>
        </div>
      </div>


      <div class="dzs-tab-tobe">
        <div class="tab-menu ">
          <span style="display: inline-block; vertical-align: middle;" class="tab-menu-title--label"><?php echo esc_html__("Sample Data", DZSVG_ID); ?></span>
          <?php
          $lab_notice = 'dzsvg_notice_sample_items_dismissed';
          if (get_option($lab_notice) == ''){

          ?>
          <span style="display: inline-block; vertical-align: middle;" class="dzstooltip-con dzsvg-notice dzsvg-notice--preview" data-lab="<?php echo $lab_notice; ?>">
            <span class="tooltip-indicator"><span  class="tooltip-info-indicator"><span class="tooltip-info-indicator--i">i</span></span></span>
            <span  class="dzstooltip  talign-center arrow-bottom style-rounded color-dark-light  dims-set transition-slidedown "  style="width: 280px;">  <span class="dzstooltip--inner">   <?php echo __("You can import examples and sample data from here."); ?>
                        <span class="dzstooltip--close"><span class="label--x-button">x</span></span>  </span> </span>
                        </span>

            <?php
            }

            ?>
        </div>
        <div class="tab-content">

          <div class="sidenote"
               style="font-size:14px;"><?php echo __('Import any of these examples with one click. ', 'dzsvg'); ?>
            <form class="no-style import-sample-items <?php

            if (get_option('dzsvg_demo_data')) {
              echo ' active-showing';
            }

            ?>" method="post">
              <button name="action" value="dzsvg_import_sample_data"><?php echo("Import sample items"); ?></button>
              <button class="only-when-active" name="action"
                      value="dzsvg_import_sample_data"><?php echo("Remove sample items"); ?></button>
            </form>
          </div>

          <div class="dzs-container">
            <div class="one-fourth ">
              <div class="feat-sample-con  import-sample import-showcase-sample-1">

                <img class="feat-sample " src="https://c3.staticflickr.com/8/7381/28034570402_7c4cd15dbe.jpg"/>
                <h4><?php echo __("9GAG.TV example"); ?></h4>
              </div>
            </div>
            <div class="one-fourth ">
              <div class="feat-sample-con  import-sample import-showcase-sample-2">

                <img class="feat-sample " src="https://i.imgur.com/iO1P255.png"/>
                <h4><?php echo __("Vimeo User Channel Wall"); ?></h4>
              </div>
            </div>
            <div class="one-fourth ">
              <div class="feat-sample-con  import-sample import-showcase-sample-3">

                <img class="feat-sample " src="https://i.imgur.com/Ma5b5Ox.png"/>
                <h4><?php echo __("Wall with Filters"); ?></h4>
              </div>
            </div>
            <!--                        <div class="one-fourth ">-->
            <!--                            <div class="feat-sample-con  import-sample import-sample-2">-->
            <!---->
            <!--                                <img class="feat-sample " src="--><?php //echo DZSVG_URL;
            ?><!--img/sample_2.jpg"/>-->
            <!--                                <h4>--><?php //echo __("YouTube Channel");
            ?><!--</h4>-->
            <!--                            </div>-->
            <!--                        </div>-->
            <!---->
            <!---->
            <!--                        <div class="one-fourth ">-->
            <!--                            <div class="feat-sample-con  import-sample import-sample-3">-->
            <!---->
            <!--                                <img class="feat-sample " src="--><?php //echo DZSVG_URL;
            ?><!--img/sample_3.jpg"/>-->
            <!--                                <h4>--><?php //echo __("Ad Before Video");
            ?><!--</h4>-->
            <!--                            </div>-->
            <!--                        </div>-->
            <!--                        <div class="one-fourth ">-->
            <!--                            <div class="feat-sample-con  import-sample import-sample-4">-->
            <!---->
            <!--                                <img class="feat-sample " src="--><?php //echo DZSVG_URL;
            ?><!--img/sample_4.jpg"/>-->
            <!--                                <h4>--><?php //echo __("Balne Layout");
            ?><!--</h4>-->
            <!--                            </div>-->
            <!--                        </div>-->
          </div>


        </div>
      </div>


    </div>
    <div class="clear"></div>
    <br/>
    <br/>
    <div class="bottom-right-buttons">

      <button id="" class="button-secondary insert-sample"><?php echo __("Sample Galleries"); ?></button>
      <button id="insert_tests" class="button-primary insert-tests"><?php echo __("Insert Gallery"); ?></button>
    </div>
    <div class="shortcode-output"></div>
  </div>
  <div class="feedbacker"><i class="fa fa-circle-o-notch fa-spin"></i><?php echo __(" Loading... "); ?></div>
  </div><?php
}