<?php


class ClassDzsvgHelpers {
  public static function sanitizeApiDescriptionToHtml($apiDescription) {


    $lb = array("\r\n", "\n", "\r");
    $apiDescription = str_replace($lb, '<br>', $apiDescription);
    $lb = array('"');
    $apiDescription = str_replace($lb, '&quot;', $apiDescription);
    $lb = array("'");
    $apiDescription = str_replace($lb, '&#39;', $apiDescription);

    $apiDescription = preg_replace('/https:\/\/.*\.(\w|\/)*/', '<a href="$0" target="_blank">$0</a>', $apiDescription);

    return $apiDescription;
  }

  public static function sanitizeWpPostToVideoItem($wpPost) {


    $lab_deprecated = 'post_content';
    $lab_correct = 'description';

    if (isset($wpPost[$lab_deprecated]) && $wpPost[$lab_deprecated]) {
      if (!(isset($wpPost[$lab_correct]) && $wpPost[$lab_correct])) {

        $wpPost[$lab_correct] = $wpPost[$lab_deprecated];
      }
    }
    $lab_deprecated = 'post_title';
    $lab_correct = 'title';

    if (isset($wpPost[$lab_deprecated]) && $wpPost[$lab_deprecated]) {
      if (!(isset($wpPost[$lab_correct]) && $wpPost[$lab_correct])) {

        $wpPost[$lab_correct] = $wpPost[$lab_deprecated];
      }
    }

    return $wpPost;
  }

  public static function detectVideoSourceFromChe($che) {

    $videoSource = '';
    if (isset($che['source']) && $che['source']) {
      $videoSource = $che['source'];
    } else {

      if (isset($che['featured_media']) && $che['featured_media']) {
        $videoSource = $che['featured_media'];
      }
    }

    return $videoSource;
  }

  public static function detectVideoType($source, $itemType) {


    if (isset($itemType) && ($itemType == '' || $itemType == 'normal')) {
      $itemType = 'video';
    }

    if ($itemType == 'detect') {

      if (strpos($source, 'vimeo.com/') !== false) {
        $itemType = 'vimeo';
      }


      if (strpos($source, '<iframe') !== false) {

        $itemType = 'inline';
      }
      if (strpos($source, 'youtube.com/') !== false) {
        $itemType = 'youtube';
      }
    }
    if ($itemType == 'detect') {

      $itemType = 'video';
    }

    if (!$itemType) {
      $itemType = '';
    }

    return $itemType;


  }


  function sanitize_forHtmlClass($arg, $pargs = array()) {


    $margs = array(
      'type' => 'image',
    );

    $margs = array_merge($margs, $pargs);


    $arg = str_replace(array(' ', '/', '\\', ':'), '', $arg);
    return $arg;

  }

  static function sanitize_idToSource($arg, $pargs = array()) {


    $margs = array(
      'type' => 'image',
    );

    $margs = array_merge($margs, $pargs);

//        echo ' arg - '.$arg;
    if (is_numeric($arg)) {

      if ($margs['type'] == 'image') {

        $imgsrc = wp_get_attachment_image_src($arg, 'full');
        return $imgsrc[0];
      }
      if ($margs['type'] == 'video') {

        $imgsrc = wp_get_attachment_url($arg);
        print_r($imgsrc);
      }


    } else {
      return $arg;
    }


  }


  static function encode_toNumber($string) {
    return substr(sprintf("%u", crc32($string)), 0, 8);
    $ans = array();
    $string = str_split($string);
    #go through every character, changing it to its ASCII value
    for ($i = 0; $i < count($string); $i++) {

      #ord turns a character into its ASCII values
      $ascii = (string)ord($string[$i]);

      #make sure it's 3 characters long
      if (strlen($ascii) < 3)
        $ascii = '0' . $ascii;
      $ans[] = $ascii;
    }

    #turn it into a string
    return implode('', $ans);
  }

  static function sanitize_forInlineContent($arg) {

    $arg = str_replace('<div', '<span', $arg);
    $arg = str_replace('</div>', '</span>', $arg);
    return $arg;
  }

  static function initRegisterPermalinksAndCpt() {

    global $dzsvg;


    $labels = array(
      'name' => esc_html__('Video galleries', 'dzsvg'),
      'singular_name' => esc_html__('Video gallery', 'dzsvg'),
      'search_items' => esc_html__('Search galleries', 'dzsvg'),
      'all_items' => esc_html__('All galleries', 'dzsvg'),
      'parent_item' => esc_html__('Parent gallery', 'dzsvg'),
      'parent_item_colon' => esc_html__('Parent gallery', 'dzsvg'),
      'edit_item' => esc_html__('Edit gallery', 'dzsvg'),
      'update_item' => esc_html__('Update gallery', 'dzsvg'),
      'add_new_item' => esc_html__('Add playlist', 'dzsvg'),
      'new_item_name' => esc_html__('New gallery name', 'dzsvg'),
      'menu_name' => esc_html__('Galleries', 'dzsvg'),
    );


    register_taxonomy(DZSVG_POST_NAME__SLIDERS, DZSVG_POST_NAME, array(

      'label' => __('Playlists', DZSVG_ID),
      'labels' => $labels,
      'query_var' => true,
      'show_ui' => true,
      'hierarchical' => false,
      'rewrite' => array('slug' => $dzsvg->mainoptions['dzsvg_sliders_rewrite']),
      'show_in_menu' => true,
    ));


    register_taxonomy(DZSVG_POST_NAME__CATEGORY, DZSVG_POST_NAME, array('label' => esc_html__('Video Categories', DZSVG_ID), 'query_var' => true, 'show_ui' => true, 'hierarchical' => true, 'rewrite' => array('slug' => $dzsvg->mainoptions['dzsvp_categories_rewrite']),));
    register_taxonomy(DZSVG_POST_NAME__TAGS, DZSVG_POST_NAME, array('label' => esc_html__('Video Tags', DZSVG_ID), 'query_var' => true, 'show_ui' => true, 'hierarchical' => false, 'rewrite' => array('slug' => $dzsvg->mainoptions['dzsvp_tags_rewrite']),));


    $labels = array('name' => $dzsvg->mainoptions['dzsvp_post_name'], 'singular_name' => $dzsvg->mainoptions['dzsvp_post_name_singular'],);

    $permalinks = get_option('dzsvp_permalinks');

    $item_slug_permalink = empty($permalinks['item_base']) ? _x('video', 'slug', 'dzsvp') : $permalinks['item_base'];


    $args = array(
      'labels' => $labels,
      'public' => true,
      'has_archive' => true,
      'hierarchical' => false,
      //                      'publicly_queryable' => true,
      //                      'exclude_from_search' => false,
      'supports' => array(
        'title',
        'editor',
        'author',
        'thumbnail',
        'post-thumbnail',
        'comments',
        'custom-fields',
        'excerpt'
      ),
      'rewrite' => array(
        'slug' => $item_slug_permalink,
      ),
      'yarpp_support' => true,
      'capabilities' => array(),
      //'taxonomies' => array('categoryportfolio'),
    );

    if ($dzsvg->mainoptions['post_is_public'] == 'off') {
      $args['public'] = false;
    }
    if ($dzsvg->mainoptions['post_show_in_nav_menus'] == 'off') {
      $args['show_in_nav_menus'] = false;
    }

    register_post_type(DZSVG_POST_NAME, $args);
  }


  public static function admin_enqueueAssetsBasedOnPage() {
    global $dzsvg;

    wp_enqueue_style('dzsvg_admin_global', DZSVG_URL . 'admin/admin_global.css');
    wp_enqueue_script('dzsvg_admin_global', DZSVG_URL . 'admin/admin_global.js');


    if ($dzsvg->mainoptions['analytics_enable'] == 'on') {

      wp_enqueue_script('google.charts', 'https://www.gstatic.com/charts/loader.js');

      if ($dzsvg->mainoptions['analytics_enable_location'] == 'on') {

        wp_enqueue_script('google.maps', 'https://www.google.com/jsapi');
      }
    }

    if (isset($_GET['page']) && ($_GET['page'] == DZSVG_PAGENAME_LEGACY_SLIDERS || $_GET['page'] == DZSVG_PAGENAME_VPCONFIGS)) {
      if ((current_user_can($dzsvg->capability_admin) || $dzsvg->mainoptions['admin_enable_for_users'] == 'on') && function_exists('wp_enqueue_media')) {
        wp_enqueue_media();
      }

      $dzsvg->classAdmin->admin_scripts();


      wp_enqueue_style('dzs.uploader', DZSVG_URL . 'admin/dzsuploader/upload.css');
      wp_enqueue_script('dzs.uploader', DZSVG_URL . "admin/dzsuploader/upload.js");
    }
    if (isset($_GET['page']) && $_GET['page'] == DZSVG_PAGENAME_LEGACY_DESIGNER_CENTER) {
      wp_enqueue_script('dzs.farbtastic', DZSVG_URL . "admin/colorpicker/farbtastic.js");
      wp_enqueue_style('dzs.farbtastic', DZSVG_URL . 'admin/colorpicker/farbtastic.css');
      wp_enqueue_script('dzsvg-dc.admin', DZSVG_URL . 'admin/admin-dc.js');
      $dzsvg->enqueue_main_scripts();
      ClassDzsvgHelpers::enqueueDzsVgPlaylist();
    }


    if (isset($_GET['taxonomy']) && $_GET['taxonomy'] == $dzsvg->taxname_sliders) {
      wp_enqueue_script('jquery-ui-sortable');
      $url = 'https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css';


      wp_enqueue_style('dzsselector', DZSVG_URL . 'libs/dzsselector/dzsselector.css');
      wp_enqueue_script('dzsselector', DZSVG_URL . 'libs/dzsselector/dzsselector.js');


      wp_enqueue_style('fontawesome', $url);
      wp_enqueue_style('dzs.tooltip', DZSVG_URL . 'libs/dzstooltip/dzstooltip.css');


//		        echo 'ceva';


      wp_enqueue_media();
    }


    if (isset($_GET['page']) && $_GET['page'] == DZSVG_PAGENAME_ABOUT) {

      $dzsvg->enqueue_main_scripts();
      ClassDzsvgHelpers::enqueueDzsVgPlaylist();
    }
    if (isset($_GET['page']) && $_GET['page'] == DZSVG_PAGENAME_MAINOPTIONS) {
      wp_enqueue_style('dzsvg_admin', DZSVG_URL . 'admin/admin.css');
      wp_enqueue_script('dzsvg_admin', DZSVG_URL . "admin/admin-mo.js");
      wp_enqueue_script('jquery-ui-core');
      wp_enqueue_script('jquery-ui-sortable');


      wp_enqueue_style('fontawesome', 'https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css');


      wp_enqueue_style('dzstabsandaccordions', DZSVG_URL . 'libs/dzstabsandaccordions/dzstabsandaccordions.css');
      wp_enqueue_script('dzstabsandaccordions', DZSVG_URL . "libs/dzstabsandaccordions/dzstabsandaccordions.js", array('jquery'));


      wp_enqueue_style('dzs.dzscheckbox', DZSVG_URL . 'assets/dzscheckbox/dzscheckbox.css');


      ClassDzsvgHelpers::enqueueDzsToggle();


      wp_enqueue_style('dzsselector', DZSVG_URL . 'libs/dzsselector/dzsselector.css');
      wp_enqueue_script('dzsselector', DZSVG_URL . 'libs/dzsselector/dzsselector.js');


      if (isset($_GET['dzsvg_shortcode_player_builder']) && $_GET['dzsvg_shortcode_player_builder'] == 'on') {


        wp_enqueue_style('dzsvg_shortcode_builder_style', DZSVG_URL . 'tinymce/popup.css');
        wp_enqueue_style('dzsvg_shortcode_player_builder_style', DZSVG_URL . 'shortcodegenerator/generator_player.css');
        wp_enqueue_script('dzsvg_shortcode_player_builder', DZSVG_URL . 'shortcodegenerator/generator_player.js');

        wp_enqueue_media();


        wp_enqueue_style('dzsulb', DZSVG_URL . 'libs/ultibox/ultibox.css');
        wp_enqueue_script('dzsulb', DZSVG_URL . 'libs/ultibox/ultibox.js');


        include_once(DZSVG_PATH . 'shortcodegenerator/generator_player.php');
        define('DONOTCACHEPAGE', true);
        define('DONOTMINIFY', true);
      }


      if (isset($_GET['dzsvg_shortcode_builder']) && $_GET['dzsvg_shortcode_builder'] == 'on') {

        wp_enqueue_style('dzsvg_shortcode_builder_style', DZSVG_URL . 'tinymce/popup.css');
        wp_enqueue_script('dzsvg_shortcode_builder', DZSVG_URL . 'tinymce/popup.js');


        ClassDzsvgHelpers::enqueueUltibox();


        wp_enqueue_media();
      }


      if (isset($_GET['dzsvg_shortcode_showcase_builder']) && $_GET['dzsvg_shortcode_showcase_builder'] == 'on') {

        wp_enqueue_style('dzsvg_shortcode_builder_style', DZSVG_URL . 'tinymce/popup.css');
        wp_enqueue_script('dzsvg_shortcode_builder', DZSVG_URL . 'tinymce/popup_showcase.js');


        wp_enqueue_style('dzsselector', DZSVG_URL . 'libs/dzsselector/dzsselector.css');
        wp_enqueue_script('dzsselector', DZSVG_URL . 'libs/dzsselector/dzsselector.js');


        wp_enqueue_style('dzstooltip', DZSVG_URL . 'libs/dzstooltip/dzstooltip.css');
        wp_enqueue_script('dzstooltip', DZSVG_URL . 'libs/dzstooltip/dzstooltip.js');


        wp_enqueue_style('dzstooltip', DZSVG_URL . 'libs/dzstooltip/dzstooltip.css');
        wp_enqueue_script('dzstooltip', DZSVG_URL . 'libs/dzstooltip/dzstooltip.js');


        wp_enqueue_media();
      }

      if (isset($_GET['dzsvg_reclam_builder']) && $_GET['dzsvg_reclam_builder'] == 'on') {

        wp_enqueue_style('dzsvg_shortcode_builder_style', DZSVG_URL . 'tinymce/popup.css');
        wp_enqueue_style('reclambuilder', DZSVG_URL . 'admin/reclam-builder/reclam-builder.css');
        wp_enqueue_script('reclambuilder', DZSVG_URL . 'admin/reclam-builder/reclam-builder.js');


        wp_enqueue_style('dzsselector', DZSVG_URL . 'libs/dzsselector/dzsselector.css');
        wp_enqueue_script('dzsselector', DZSVG_URL . 'libs/dzsselector/dzsselector.js');


        wp_enqueue_style('dzstooltip', DZSVG_URL . 'libs/dzstooltip/dzstooltip.css');
        wp_enqueue_script('dzstooltip', DZSVG_URL . 'libs/dzstooltip/dzstooltip.js');
        wp_enqueue_media();


      }

      if (isset($_GET['dzsvg_quality_builder']) && $_GET['dzsvg_quality_builder'] == 'on') {

        wp_enqueue_style('dzsvg_shortcode_builder_style', DZSVG_URL . 'tinymce/popup.css');
        wp_enqueue_style('qualitybuilder', DZSVG_URL . 'admin/quality-builder/quality-builder.css');
        wp_enqueue_script('qualitybuilder', DZSVG_URL . 'admin/quality-builder/quality-builder.js');


        wp_enqueue_style('dzsselector', DZSVG_URL . 'libs/dzsselector/dzsselector.css');
        wp_enqueue_script('dzsselector', DZSVG_URL . 'libs/dzsselector/dzsselector.js');


        wp_enqueue_style('dzstooltip', DZSVG_URL . 'libs/dzstooltip/dzstooltip.css');
        wp_enqueue_script('dzstooltip', DZSVG_URL . 'libs/dzstooltip/dzstooltip.js');
        wp_enqueue_media();


      }


    }

    if (current_user_can('video_gallery_edit_own_galleries') || current_user_can('video_gallery_edit_others_galleries') || current_user_can('manage_options')) {

      wp_enqueue_script('dzsvg_htmleditor', DZSVG_URL . 'tinymce/plugin-htmleditor.js', array('jquery'), DZSVG_VERSION);
      wp_enqueue_script('dzsvg_configreceiver', DZSVG_URL . 'tinymce/receiver.js');
    }
  }

  public static function sanitizeToPhpId($s) {
    return preg_replace("/[^a-zA-Z0-9]+/", "", $s);
  }


  public static function assertIfPageCanHaveGutenbergBlocks() {
    global $post;

    $current_screen = dzs_get_current_screen();
    if (isset($post) &&
      (
        ($current_screen['base'] == 'post' && (isset($post->post_content) && strpos($post->post_content, 'wp:') !== false)) ||
        ($current_screen['base'] == 'post' && ($current_screen['action'] == 'new' || $current_screen['action'] == 'add'))
        || ($current_screen['base'] == 'post' && $current_screen['action'] != 'new' && (function_exists('has_blocks') && has_blocks($post->ID)) || (isset($post->post_content) && $post->post_content === ''))
      )
    ) {

      return true;
    }

    return false;
  }

  public static function navigationPrepareOptions(&$its) {

    global $dzsvg;
    if (isset($its['settings']['html5designmiw']) && $its['settings']['html5designmiw'] == 'default') {
      if ($dzsvg->mainoptions['use_layout_builder_on_navigation'] == 'on') {
        $its['settings']['html5designmiw'] = '';
      } else {
        $its['settings']['html5designmiw'] = '275';
      }
    }
    if (isset($its['settings']['html5designmih']) && $its['settings']['html5designmih'] == 'default') {
      if ($dzsvg->mainoptions['use_layout_builder_on_navigation'] == 'on') {
        $its['settings']['html5designmih'] = '';
      } else {
        $its['settings']['html5designmih'] = '100';
      }
    }
    if (isset($its['settings']['view_navigation_space']) && $its['settings']['view_navigation_space'] == 'default') {
      if ($dzsvg->mainoptions['use_layout_builder_on_navigation'] == 'on') {
        $its['settings']['view_navigation_space'] = '';
      } else {
        $its['settings']['view_navigation_space'] = '10';
      }
    }

  }

  /**
   * @param string $thumbSrc
   * @param array $che
   * @return string|null
   */
  public static function sanitizeCheToThumbnailUrlSource($thumbSrc = '', $che = array()) {


    if (isset($thumbSrc) && $thumbSrc) {


    } else {

      if (isset($che['type']) && $che['type'] == 'youtube') {
        $thumbSrc = '{ytthumb}';
      }
    }
    if ($thumbSrc == '{ytthumb}') {

      $thumbSrc = 'http://i3.ytimg.com/vi/' . ClassDzsvgHelpers::youtube_getSource($che['source']) . '/hqdefault.jpg';;
    }
    return $thumbSrc;
  }

  public static function youtube_getSource($url) {
    parse_str(parse_url($url, PHP_URL_QUERY), $my_array_of_vars);
    if (isset($my_array_of_vars['v'])) {

      return $my_array_of_vars['v'];
    }

    return $url;
  }

  public static function autoupdaterUpdate($zipUrl = '', $zipTargetPath = '') {


    global $dzsvg;
    if (!$zipUrl) {
      $zipUrl = 'https://zoomthe.me/updater_dzsvg/servezip.php?purchase_code=' . $dzsvg->mainoptions['dzsvg_purchase_code'] . '&site_url=' . site_url();
    }
    if (!$zipTargetPath || $zipTargetPath == '') {
      $zipTargetPath = DZSVG_PATH . 'update.zip';
    }

    $res = DZSHelpers::get_contents($zipUrl);

    //            echo 'hmm'; echo strpos($res,'<div class="error">'); echo 'dada'; echo $res;
    if ($res === false) {
      echo 'server offline';
    } else {
      if (strpos($res, '<div class="error') === 0) {
        echo $res;


        if (strpos($res, '<div class="error">error: in progress') === 0) {

          $dzsvg->mainoptions['dzsvg_purchase_code_binded'] = 'on';
          update_option(DZSVG_DBKEY_MAINOPTIONS, $dzsvg->mainoptions);
        }
        return false;
      } else {

        file_put_contents($zipTargetPath, $res);
        if (class_exists('ZipArchive')) {
          $zip = new ZipArchive;
          $zipOpenResp = $zip->open($zipTargetPath);
          //test
          if ($zipOpenResp === TRUE) {
            //                echo 'ok';
            $zip->extractTo(DZSVG_PATH);
            $zip->close();


            $dzsvg->mainoptions['dzsvg_purchase_code_binded'] = 'on';
            update_option(DZSVG_DBKEY_MAINOPTIONS, $dzsvg->mainoptions);


            echo esc_html__('Update succesful.', DZSVG_ID);
            return true;
          } else {
            echo 'failed, code:' . $res;
          }
        } else {

          echo __('ZipArchive class not found.');
        }

      }
    }
    return false;
  }


  static function sanitize_description($desc, $pargs = array()) {

    $fout = $desc;

    $margs = array('desc_count' => 'default', 'striptags' => 'on', 'try_to_close_unclosed_tags' => 'on', 'desc_readmore_markup' => '',);
    if (is_array($pargs) == false) {
      $pargs = array();
    }
    $margs = array_merge($margs, $pargs);


    $maxlen = 100;
    if ($margs['desc_count']) {
      $maxlen = $margs['desc_count'];
    }


//            echo 'maxlen - '.$maxlen;

    $striptags = false;

    if ($margs['striptags'] == 'on') {
      $striptags = true;
    }

    $try_to_close_unclosed_tags = true;


    if ($striptags) {
      $try_to_close_unclosed_tags = false;
    }
    if ($margs['try_to_close_unclosed_tags'] == 'on') {
      $try_to_close_unclosed_tags = false;
    }
    $try_to_close_unclosed_tags = false;


    if ($desc) {
      $fout = '' . dzs_get_excerpt(-1, array('content' => $desc, 'maxlen' => $maxlen, 'try_to_close_unclosed_tags' => $try_to_close_unclosed_tags, 'striptags' => $striptags, 'readmore' => 'auto', 'readmore_markup' => $margs['desc_readmore_markup'],));
    }

    return $fout;
  }


  static function sanitize_anchorsTextToHtml($arg) {

    $fout = '';


    $fout = $arg;

    $fout = preg_replace("/(?<![\"|'])(http[s]*:\/\/.*?)(?= |$|<br>|\<)/mi", ' <a href="$0" target="_blank">$0</a>', $arg);


    return $fout;
  }


  /**
   * @param $argId string vpsetting id
   * @return mixed
   */
  public static function view_getVpConfig($argId) {


    // @arg -

    global $dzsvg;

    $i = 0;
    $vpconfig_k = 0;
    $vpconfig_id = $argId;
    for ($i = 0; $i < count($dzsvg->mainvpconfigs); $i++) {
      if ((isset($vpconfig_id)) && ($vpconfig_id == $dzsvg->mainvpconfigs[$i]['settings']['id'])) {
        $vpconfig_k = $i;
      }
    }
    $vpsettings = $dzsvg->mainvpconfigs[$vpconfig_k];

    if (!isset($vpsettings['settings']) || $vpsettings['settings'] == '') {
      $vpsettings['settings'] = array();
    }

    $vpsettings['settings'] = array_merge($dzsvg->vpsettingsdefault, $vpsettings['settings']);

    unset($vpsettings['settings']['id']);

    $vpsettings['settings']['vpconfig_id'] = $vpconfig_id;
    return $vpsettings;
  }

  public static function enqueueUltibox() {

    wp_enqueue_style('dzsulb', DZSVG_URL . 'libs/ultibox/ultibox.css');
    wp_enqueue_script('dzsulb', DZSVG_URL . 'libs/ultibox/ultibox.js', array(), DZSVG_VERSION);


    $playerSkin = DZSVG_VIEW_ULTIBOX_DZSVG_PLAYER_SKIN;
    wp_enqueue_style('dzsvp_skin_' . $playerSkin, DZSVG_URL . 'videogallery/parts/player-skins/player-skin--' . $playerSkin . '.css', null, DZSVG_VERSION);
  }

  public static function enqueueDzsVgPlaylist() {
    global $dzsvg;

    $js_url = DZSVG_SCRIPT_URL . "vgallery.js";
    $css_url = DZSVG_SCRIPT_URL . "vgallery.css";


    if ($dzsvg->mainoptions['enable_ie11_compatibility'] === 'on') {
      $js_url = DZSVG_SCRIPT_URL . "deprecated/vgallery.ie11.js";
    }

    wp_enqueue_style('dzsvg_playlist', $css_url, array(), DZSVG_VERSION);
    wp_enqueue_script('dzsvg_playlist', $js_url, array('jquery'), DZSVG_VERSION);

  }

  public static function addAnalyticsButtonPlaylist() {

    $fout = '';
    if (current_user_can('manage_options')) {

      $fout .= '<div class="extra-btns-con">';
      $fout .= '<span class="btn-zoomsounds stats-btn" data-playerid="' . '' . '"><span class="the-icon"><i class="fa fa-tachometer" aria-hidden="true"></i></span><span class="btn-label">' . esc_html__('Stats', 'dzsvg') . '</span></span>';
      $fout .= '</div>';


      ClassDzsvgHelpers::enqueueDzsVgShowcase();
    }

    return $fout;

  }


  public static function enqueueDzsVgShowcase() {

    wp_enqueue_style('dzsvg_showcase', DZSVG_URL . 'libs/video-portal/front-dzsvp.css');
    wp_enqueue_script('dzsvg_showcase', DZSVG_URL . 'libs/video-portal/front-dzsvp.js');
  }

  public static function enqueuePlayerSkin($playerSkin = '') {

    wp_enqueue_style('dzsvp_skin_' . $playerSkin, DZSVG_URL . 'videogallery/parts/player-skins/player-skin--' . $playerSkin . '.css', null, DZSVG_VERSION);
  }

  public static function enqueueDzsToggle() {

    wp_enqueue_style('dzstoggle', DZSVG_URL . 'libs/dzstoggle/dzstoggle.css', null, DZSVG_VERSION);
    wp_enqueue_script('dzstoggle', DZSVG_URL . 'libs/dzstoggle/dzstoggle.js', null, DZSVG_VERSION);
  }

  public static function assets_getUrlForHelperImage($helperImageName = '') {

    $prefix = 'https://www.dropbox.com/s/t451p4x5km2yiad/';
    $suffix = '?dl=1';


    return $prefix . $helperImageName . $suffix;

  }

  public static function generateHtmlLegacySlider($vpconfigsstr) {
    global $dzsvg;


    $uploadbtnstring = '<button class="button-secondary action upload_file">' . __("Upload", 'dzsvg') . '</button>';
    $uploadbtnstring_video = '<button class="button-secondary action upload_file only-video upload-type-video">' . __("Upload", 'dzsvg') . '</button>';
    $fout = '<div class="slider-con" style="display:none;">
        <div class="setting type_all">
            <div class="setting-label">' . __('Select Feed Mode', 'dzsvg') . '</div>
                <div class="main-feed-chooser select-hidden-metastyle">
                <select class="textinput mainsetting" name="0-settings-feedfrom">
                    <option value="normal">' . __('Normal', 'dzsvg') . '</option>
                    <option value="ytuserchannel">' . __('Youtube User Channel', 'dzsvg') . '</option>
                    <option value="ytplaylist">' . __('YouTube Playlist', 'dzsvg') . '</option>
                    <option value="ytkeywords">' . __('YouTube Keywords', 'dzsvg') . '</option>
                    <option value="vmuserchannel">' . __('Vimeo User Channel', 'dzsvg') . '</option>
                    <option value="vmchannel">' . __('Vimeo Channel', 'dzsvg') . '</option>
                    <option value="vmalbum">' . __('Vimeo Album', 'dzsvg') . '</option>
                    <option value="facebook">' . __('Facebook feed', 'dzsvg') . '</option>
                </select>
                <div class="option-con clearfix">
                    <div class="an-option">
                    <div class="an-title">
                    ' . __('Normal', 'dzsvg') . '
                    </div>
                    <div class="an-desc">
                    ' . __('Feed from custom items you set below.', 'dzsvg') . '
                    </div>
                    </div>
                    
                    <div class="an-option">
                    <div class="an-title">
                    ' . __('Youtube User Channel', 'dzsvg') . '
                    </div>
                    <div class="an-desc">
                    ' . __(' Feed videos from your YouTube User Channel.', 'dzsvg') . '
                   
                    </div>
                    </div>
                    
                    <div class="an-option">
                    <div class="an-title">
                    ' . __('YouTube Playlist', 'dzsvg') . '
                    </div>
                    <div class="an-desc">
                    ' . __('Feed videos from the YouTube Playlist you create on their site. Just input the Playlist ID below.', 'dzsvg') . '
                    
                    </div>
                    </div>
                    
                    <div class="an-option">
                    <div class="an-title">
                    ' . __('YouTube Keywords', 'dzsvg') . '
                    </div>
                    <div class="an-desc">
                    ' . sprintf(__('Feed videos by searching for keywords ie. %sfunny cat%s', 'dzsvg'), '<strong>', '</strong>') . '
                    </div>
                    </div>
                    
                    <div class="an-option">
                    <div class="an-title">
                    ' . __('Vimeo User Channel', 'dzsvg') . '
                    </div>
                    <div class="an-desc">
                    ' . __('Feed videos from your Vimeo User channel.', 'dzsvg') . '
                    </div>
                    </div>
                    
                    <div class="an-option">
                    <div class="an-title">
                    ' . __('Vimeo Channel', 'dzsvg') . '
                    </div>
                    <div class="an-desc">
                    ' . __('Feed videos from a Vimeo Channel.', 'dzsvg') . '
                    </div>
                    </div>
                    
                    <div class="an-option">
                    <div class="an-title">
                    ' . __('Vimeo Album', 'dzsvg') . '
                    </div>
                    <div class="an-desc">
                    ' . __('Feed videos from a Vimeo Album.', 'dzsvg') . '
                    </div>
                    </div>
                    
                    <div class="an-option">
                    <div class="an-title">
                    ' . __('Facebook feed', 'dzsvg') . '
                    </div>
                    <div class="an-desc">
                    ' . __('input a facebook link', 'dzsvg') . '
                    </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="settings-con">
        <h4>' . __('General Options', 'dzsvg') . '</h4>
        <div class="setting type_all">
            <div class="setting-label">' . __('ID', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting main-id" name="0-settings-id" value="default"/>
            <div class="sidenote">' . __('Choose an unique id. Do not use spaces, do not use special characters.', 'dzsvg') . '</div>
        </div>
        <div class="setting type_all">
            <div class="setting-label">' . __('Force Height', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-height" value=""/>
        </div>
        <div class="setting styleme">
            <div class="setting-label">' . __('Display Mode', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme has-extra-desc" name="0-settings-displaymode">
                <option>normal</option>
                <option>wall</option>
                <option>rotator</option>
                <option>rotator3d</option>
                <option>slider</option>
                <option>videowall</option>    
            </select>
            
            <div class="extra-desc">
            
            
            <div class="bigoption select-option ">
            <div class="option-con">
            <div class="divimage" data-src="https://i.imgur.com/3iRmYlc.jpg"></div>
            <span class="option-label">' . esc_html__("Default", DZSVG_ID) . '</span>
            </div>
            </div>
            
            <div class="bigoption select-option ">
            <div class="option-con">
            <div class="divimage" data-src="https://i.imgur.com/YhYVMd9.jpg"></div>
            <span class="option-label">' . __("Wall") . '</span>
            </div>
            </div>
            
            <div class="bigoption"></div>
            
            <div class="bigoption select-option ">
            <div class="option-con">
            <div class="divimage" data-src="https://i.imgur.com/wQrkSkv.jpg"></div>
            <span class="option-label">' . __("Rotator 3D") . '</span>
            </div>
            </div>
            
            
            <div class="bigoption"></div>
            
            <div class="bigoption select-option ">
            <div class="option-con">
            <div class="divimage" data-src="https://i.imgur.com/1jThnc7.jpg"></div>
            <span class="option-label">' . __("Video Wall") . '</span>
            </div>
            </div>
            
            
            
            </div>
            
            
            
        </div>
        <div class="setting styleme">
            <div class="setting-label">' . __('Video Gallery Skin', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-skin_html5vg">
                <option value="skin-default">' . __("Default", 'dzsvg') . ' </option>
                <option value="skin-pro">' . __("Skin", 'dzsvg') . ' Pro </option>
                <option value="skin-boxy">' . __("Skin", 'dzsvg') . ' Boxy </option>
                <option value="skin-boxy skin-boxy--rounded">' . __("Skin", 'dzsvg') . ' Boxy Rounded</option>
                <option value="skin-aurora">' . __("Skin", 'dzsvg') . ' Aurora</option>
                <option value="skin-navtransparent">' . __("Skin", 'dzsvg') . ' NavTransparent</option>
                <option value="skin-custom">' . __("Custom Skin", 'dzsvg') . '</option>
            </select>
            <div class="sidenote">' . __('Skin Custom can be modified via Designer Center.', 'dzsvg') . '</div>
        </div>
        
        
        <div class="setting type_all">
            <div class="setting-label">' . __('Video Player Configuration', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-vpconfig">
                <option value="default">' . __('default', 'dzsvg') . '</option>
                ' . $vpconfigsstr . '
            </select>
            <div class="sidenote" style="">' . __('setup these inside the <strong>Video Player Configs</strong> admin', 'dzsvg') . ' <a id="quick-edit" class="quick-edit-vp" href="' . admin_url('admin.php?page=' . DZSVG_PAGENAME_VPCONFIGS . '&currslider=0&from=shortcodegenerator') . '" class="sidenote" style="cursor:pointer;">' . __("Quick Edit ") . '</a></div>
        </div>
        
        <div class="setting type_all">
            <div class="setting-label">' . __('Navigation Style', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme dzs-dependency-field" name="0-settings-nav_type">
                <option>thumbs</option>
                <option>thumbsandarrows</option>
                <option>scroller</option>
                <option>outer</option>
                <option>none</option>
            </select>
            <div class="sidenote">' . __('Choose a navigation style for the normal display mode.', 'dzsvg') . '</div>
        </div>';


    $dependency = array(

      array(
        'lab' => '0-settings-nav_type',
        'val' => array('outer'),
      ),
    );


    $dependency = json_encode($dependency);
    $fout .= '<div class="setting type_all"  data-dependency=\'' . $dependency . '\'">
            <div class="setting-label">' . __('Max. Height For Navigation', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-nav_type_outer_max_height" value=""/>
            <div class="sidenote" style="">' . __('input a maximum height for the outer navigation ( only for bottom and top menu positions ) - if the content is larger, then a scrollbar will appear', 'dzsvg') . '</div>
        </div>
        
        
        <div class="setting type_all">
            <div class="setting-label">' . __('Menu Position', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-menuposition">
                <option>right</option>
                <option>bottom</option>
                <option>left</option>
                <option>top</option>
                <option>none</option>
            </select>
        </div>
        <div class="setting type_all">
            <div class="setting-label">' . __('Autoplay', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-autoplay">
                <option value="on">' . __('on', 'dzsvg') . '</option>
                <option value="off">' . __('off', 'dzsvg') . '</option>
            </select>
        </div>
        <div class="setting type_all">
            <div class="setting-label">' . __('Autoplay Next', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-autoplaynext">
                <option value="on">' . __('on', 'dzsvg') . '</option>
                <option value="off">' . __('off', 'dzsvg') . '</option>
            </select>
            <div class="sidenote">' . __('autoplay next track when selecting in the menu or when the current video has ended', 'dzsvg') . '</div>
        </div>
        <div class="setting type_all">
            <div class="setting-label">' . __('Cue First Video', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-cueFirstVideo">
                <option value="on">' . __('on', 'dzsvg') . '</option>
                <option value="off">' . __('off', 'dzsvg') . '</option>
            </select>
            <div class="sidenote">' . __('Choose if the video should load at start or it should activate on click ( if a <strong>Cover Image</strong> is set ).', 'dzsvg') . '</div>
            
        </div>
        <div class="setting type_all">
            <div class="setting-label">' . __('Randomize / Shuffle Elements', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-randomize">
                <option value="off">' . __('off', 'dzsvg') . '</option>
                <option value="on">' . __('on', 'dzsvg') . '</option>
            </select>
        </div>
        <div class="setting type_all">
            <div class="setting-label">' . __('Order', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-order">
                <option value="ASC">' . __('ascending', 'dzsvg') . '</option>
                <option value="DESC">' . __('descending', 'dzsvg') . '</option>
            </select>
        </div>
        
        <div class="setting type_all">
            <div class="setting-label">' . __('Transition', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-transition">
                <option value="fade">' . __('Fade', 'dzsvg') . '</option>
                <option value="slidein">' . __('Slide In', 'dzsvg') . '</option>
            </select>
            <div class="sidenote" style="">' . __('set the transition of the gallery  ( when it loads ) ', 'dzsvg') . '</div>
        </div>

        <div class="setting type_all">
            <div class="setting-label">' . __('Enable Underneath Description', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-enableunderneathdescription">
                <option value="off">' . __('off', 'dzsvg') . '</option>
                <option value="on">' . __('on', 'dzsvg') . '</option>
            </select>
            <div class="sidenote" style="">' . __('add a title and description holder underneath the gallery', 'dzsvg') . '</div>
        </div>

        <div class="setting type_all">
            <div class="setting-label">' . __('Enable Search Field', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme  dzs-dependency-field" name="0-settings-enable_search_field">
                <option value="off">' . __('off', 'dzsvg') . '</option>
                <option value="on">' . __('on', 'dzsvg') . '</option>
            </select>
            <div class="sidenote" style="">' . __('enable a search field inside the gallery', 'dzsvg') . '</div>
        </div>';


    $dependency = array(
      array(
        'lab' => '0-settings-enable_search_field',
        'val' => array('on'),
      ),
    );


    $dependency = json_encode($dependency);
    $fout .= '<div class="setting type_all"  data-dependency=\'' . $dependency . '\'">
            <div class="setting-label">' . esc_html__('Search Field Location', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-search_field_location">
                <option value="outside">' . esc_html__('Outside Gallery', 'dzsvg') . '</option>
                <option value="inside">' . esc_html__('Inside Gallery', 'dzsvg') . '</option>
            </select>
            <div class="sidenote" style="">' . __('search bar location', 'dzsvg') . '</div>
        </div>

        <div class="setting type_all">
            <div class="setting-label">' . esc_html__('Enable Linking', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-settings_enable_linking">
                <option value="off">' . esc_html__('off', 'dzsvg') . '</option>
                <option value="on">' . esc_html__('on', 'dzsvg') . '</option>
            </select>
            <div class="sidenote" style="">' . esc_html__('enable the possibility for the gallery to change the current link depending on the video played, this makes it easy to go to a current video based only on link', 'dzsvg') . '</div>
        </div>


        <div class="setting type_all">
            <div class="setting-label">' . esc_html__('Autoplay Ad', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-autoplay_ad">
            </select>
            <div class="sidenote" style="">' . esc_html__('autoplay the ad before a video or not - note that if the video autoplay then the ad will autoplay too before', 'dzsvg') . '</div>
        </div>
        
        
        <div class="setting type_all">
            <div class="setting-label">' . esc_html__('Resize Video Proportionally', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-set_responsive_ratio_to_detect">
                <option value="on">' . esc_html__('on', 'dzsvg') . '</option>
                <option value="off">' . esc_html__('off', 'dzsvg') . '</option>
            </select>
        </div>
        <div class="sidenote">' . __('Settings this to "on" will make an attempt to remove the black bars plus resizing the video proportionally for mobiles.', 'dzsvg') . '</div>


        <hr/>
<div class="dzstoggle toggle1" rel="">
<div class="toggle-title" style="">' . __('Social Options', 'dzsvg') . '</div>
<div class="toggle-content">

        <div class="setting type_all">
            <div class="setting-label">' . __('Share Button', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-sharebutton">
                <option value="off">' . __('off', 'dzsvg') . '</option>
                <option value="on">' . __('on', 'dzsvg') . '</option>
            </select>
        </div>
        <div class="setting type_all">
            <div class="setting_label">' . __('Facebook Link', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-facebooklink" value=""/>
            <div class="sidenote" style="">' . __('input here a full link to your facebook page ie. <strong><a href="https://www.facebook.com/digitalzoomstudio">https://www.facebook.com/digitalzoomstudio</a></strong> or input "<strong>{{share}}</strong>" and the button will share the current playing video', 'dzsvg') . '</div>
        </div>
        <div class="setting type_all">
            <div class="setting_label">' . __('Twitter Link', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-twitterlink" value=""/>
        </div>
        <div class="setting type_all">
            <div class="setting_label">' . __('Google Plus Link', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-googlepluslink" value=""/>
        </div>
        <div class="setting type_all">
            <div class="setting_label">' . __('Extra Social HTML', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-social_extracode" value=""/>
            <div class="sidenote" style="">' . __('you can have here some extra social icons', 'dzsvg') . '</div>
        </div>
        <div class="setting type_all">
            <div class="setting-label">' . __('Embed Button', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-embedbutton">
                <option value="off">' . __('off', 'dzsvg') . '</option>
                <option value="on">' . __('on', 'dzsvg') . '</option>
            </select>
        </div>
        
        
        <div class="setting">
            <div class="setting_label">' . __('Logo', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-logo" value=""/>' . $uploadbtnstring . '
        </div>
        <div class="setting">
            <div class="setting_label">' . __('Logo Link', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-logoLink" value=""/>
        </div>
</div>
</div>
<div class="dzstoggle toggle1" rel="">
<div class="toggle-title" style="">' . __('Menu Options', 'dzsvg') . '</div>
<div class="toggle-content">

        <div class="setting type_all">
            <div class="setting-label">' . __('Design Menu Item Width', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-html5designmiw" value="275"/>
            <div class="sidenote" style="">' . __('these also control the width and height for wall items', 'dzsvg') . '</div>
        </div>
        <div class="setting type_all">
            <div class="setting-label">' . esc_html__('Design Menu Item Height', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-html5designmih" value="76"/>
            <div class="sidenote" style="">' . __('these also control the width and height for wall items ( for auto height leave blank here, on wall mode )', 'dzsvg') . '</div>
        </div>
        <div class="setting type_all">
            <div class="setting-label">' . esc_html__('Design Menu Item Space', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-html5designmis" value="0"/>
        </div>

        <div class="setting type_all">
            <div class="setting-label">' . esc_html__('Thumbnail Extra Classes', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-thumb_extraclass" value=""/>
            <div class="sidenote" style="">' . __('add a special class to the thumbnail like <strong>thumb-round</strong> for making the thumbnails rounded', 'dzsvg') . '</div>
        </div>
        
        
        <div class="setting type_all">
            <div class="setting-label">' . esc_html__('Disable Menu Description', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-disable_menu_description">
                <option>off</option>
                <option>on</option>
            </select>
        </div>
        <div class="setting type_all">
            <div class="setting-label">' . __('Enable Easing on Menu', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-design_navigationuseeasing">
                <option>off</option>
                <option>on</option>
            </select>
                <div class="sidenote" style="">' . __('for navigation type <strong>thumbs</strong> - use a easing on mouse tracking ', 'dzsvg') . '</div>
        </div>
        
        
        
        <div class="setting type_all">
            <div class="setting-label">' . __('Lock Scroll', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-nav_type_auto_scroll">
                <option>off</option>
                <option>on</option>
            </select>
                <div class="sidenote" style="">' . __('for navigation type <strong>thumbs</strong> - LOCK SCROLL to current item ', 'dzsvg') . '</div>
        </div>
        
        
        <div class="setting type_all">
            <div class="setting-label">' . esc_html__('Menu Item Format', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-menu_description_format" value=""/>
            <div class="sidenote" style="">' . sprintf(__('you can use something like %s{{number}}{{menuimage}}{{menutitle}}{{menudesc}}%s to display - menu item number , menu image, title and description or leave blank for default mode', 'dzsvg'), '<strong>', '</strong>') . '</div>
        </div>
        

</div>
</div>
<div class="dzstoggle toggle1" rel="">
<div class="toggle-title" style="">' . __('Design Options', 'dzsvg') . '</div>
<div class="toggle-content">


        <div class="setting type_all">
            <div class="setting-label">' . __('Max Width', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-max_width" value=""/>
            <div class="sidenote">' . __('Limit the max width of the gallery ( in pixels ) and center the gallery ', 'dzsvg') . '</div>
        </div>




        <div class="setting">
            <div class="setting_label">' . __('Cover Image', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-coverImage" value=""/>' . $uploadbtnstring . '
                <div class="sidenote">A image that appears while the video is cued / not played</div>
        </div>


        <div class="setting type_all">
            <div class="setting-label">' . __('Navigation Space', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-nav_space" value="0"/>
            <div class="sidenote" style="">' . __('space between navigation and video container', 'dzsvg') . '</div>
        </div>
        <div class="setting type_all">
            <div class="setting-label">' . __('Disable Menu Title', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-disable_title">
                <option>off</option>
                <option>on</option>
            </select>
        </div>
        <div class="setting type_all">
            <div class="setting-label">' . __('Disable Video Title', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-disable_video_title">
                <option>off</option>
                <option>on</option>
            </select>
        </div>

        <div class="setting type_all">
            <div class="setting-label">' . __('Laptop Skin', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-laptopskin">
                <option value="off">' . __('off', 'dzsvg') . '</option>
                <option value="on">' . __('on', 'dzsvg') . '</option>
            </select>
                <div class="sidenote" style="">' . __('apply a laptop container to the gallery', 'dzsvg') . '</div>
        </div>
        <div class="setting type_all">
            <div class="setting-label">' . __('Transition', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-html5transition">
                <option>slideup</option>
                <option>fade</option>
            </select>
        </div>

        <div class="setting type_all">
            <div class="setting-label">' . __('Right to Left', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-rtl">
                <option value="off">' . __('off', 'dzsvg') . '</option>
                <option value="on">' . __('on', 'dzsvg') . '</option>
            </select>
            <div class="sidenote" style="">' . __('enable RTL', 'dzsvg') . '</div>
        </div>



        <div class="setting">
            <div class="setting-label">' . __('Extra Classes', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-extra_classes" value=""/>
            <div class="sidenote" style="">' . __('some extra css classes that you can use to stylize this gallery', 'dzsvg') . '</div>
        </div>



        <div class="setting">
            <div class="setting-label">' . __('Background', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting with-colorpicker" name="0-settings-bgcolor" value="#444444"/><div class="picker-con"><div class="the-icon"></div><div class="picker"></div></div>
        </div>

        <div class="setting type_all">
            <div class="setting-label">' . __('Enable Shadow', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-shadow">
                <option value="off">' . __('off', 'dzsvg') . '</option>
                <option value="on">' . __('on', 'dzsvg') . '</option>
            </select>
        </div>
        
        
<div class="dzstoggle toggle1" rel="">
<div class="toggle-title" style="">' . __('Force Sizes', 'dzsvg') . '</div>
<div class="toggle-content">

        <div class="setting type_all">
            <div class="setting-label">' . __('Force Width', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-width" value="100%"/>
            <div class="sidenote">' . __('Leave "100%" for responsive mode. ', 'dzsvg') . '</div>
        </div>
        <div class="setting type_all">
            <div class="setting-label">' . __('Force Video Height', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-forcevideoheight" value=""/>
        <div class="sidenote">' . __('Leave this blank if you want the video to autoresize. .', 'dzsvg') . '</div>
        </div>
</div></div>

        <h5>' . __('Mode Wall Settings') . '</h5>

        <div class="setting type_all">
            <div class="setting-label">' . __('Layout for Mode Wall', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-mode_wall_layout">
                <option value="none">' . __('None', 'dzsvg') . '</option>
                <option value="dzs-layout--1-cols">' . __('1 column', 'dzsvg') . '</option>
                <option value="dzs-layout--2-cols">' . __('2 columns', 'dzsvg') . '</option>
                <option value="dzs-layout--3-cols">' . __('3 columns', 'dzsvg') . '</option>
                <option value="dzs-layout--4-cols">' . __('4 columns', 'dzsvg') . '</option>
            </select>
                <div class="sidenote" style="">' . __('the layout for the wall mode. using none will use the Design Menu Item Width and Design Menu Item Height for the item dimensions', 'dzsvg') . '</div>
        </div>


        <br>
</div>
</div>


<div class="dzstoggle toggle1" rel="">
<div class="toggle-title" style="">' . __('Description Options', 'dzsvg') . '</div>
<div class="toggle-content">
        <div class="sidenote" style="font-size:14px;">' . __('some options regarding YouTube feed mode - playlist / user channel / ', 'dzsvg') . '</div>
        <div class="setting type_all">
            <div class="setting-label">' . __('Max Description Length', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-maxlen_desc" value="250"/>
            <div class="sidenote" style="">' . __('youtube video descriptions will be retrieved through YouTube Data API. You can choose here the number of characters to retrieve from it. ', 'dzsvg') . '</div>
        </div>
        <div class="setting type_all">
            <div class="setting-label">' . __('Read More Markup ', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-readmore_markup" value="<p><a class=ignore-zoombox href={{postlink}}>' . __('read more') . ' &raquo;</a></p>"/>
            <div class="sidenote" style="">' . '' . '</div>
        </div>
        <div class="setting type_all">
            <div class="setting-label">' . __('Strip HTML Tags', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-striptags">
                <option value="on">' . __('on', 'dzsvg') . '</option>
                <option value="off">' . __('off', 'dzsvg') . '</option>
                </select>
            <div class="sidenote" style="">' . __('video descriptions will be retrieved as html rich content. you can choose to strip the html tags to leave just simple text ', 'dzsvg') . '</div>
        </div>
        <div class="setting type_all">
            <div class="setting-label">' . __('Repair HTML Markup', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-try_to_close_unclosed_tags">
                <option value="on">' . __('on', 'dzsvg') . '</option>
                <option value="off">' . __('off', 'dzsvg') . '</option>
                </select>
            <div class="sidenote" style="">' . __('video descriptions will be retrieved as html rich content, some may be broken after shortage. attempt to repair this by setting this to <strong>on</strong>', 'dzsvg') . '</div>
        </div>';


    $lab = '0-settings-desc_different_settings_for_aside';
//                                echo DZSHelpers::generate_input_text($lab,array('id' => $lab, 'val' => 'off','input_type'=>'hidden'));
    $fout .= '<div class="setting">
                                    <h4 class="setting-label">' . __('Aside Navigation has Different Settings?', 'dzsvg') . '</h4>
                                    <div class="dzscheckbox skin-nova">
                                        ' . DZSHelpers::generate_input_checkbox($lab, array('id' => $lab, 'class' => 'mainsetting', 'val' => 'on', 'seekval' => '')) . '
                                        <label for="' . $lab . '"></label>
                                    </div>
                                    <div class="sidenote">' . __('allow creating new accounts') . '</div>
                                </div>';


    $fout .= '



<div class="setting type_all appear-only-when-is-on-desc_different_settings_for_aside">
            <div class="setting-label">' . __('Max Description Length', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-desc_aside_maxlen_desc" value="250"/>
            <div class="sidenote" style="">' . __('youtube video descriptions will be retrieved through YouTube Data API. You can choose here the number of characters to retrieve from it. ', 'dzsvg') . '</div>
</div>
<div class="setting type_all appear-only-when-is-on-desc_different_settings_for_aside">
            <div class="setting-label">' . __('Strip HTML Tags', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-desc_aside_striptags">
                <option value="on">' . __('on', 'dzsvg') . '</option>
                <option value="off">' . __('off', 'dzsvg') . '</option>
                </select>
            <div class="sidenote" style="">' . __('video descriptions will be retrieved as html rich content. you can choose to strip the html tags to leave just simple text ', 'dzsvg') . '</div>
</div>
<div class="setting type_all appear-only-when-is-on-desc_different_settings_for_aside">
            <div class="setting-label">' . __('Repair HTML Markup', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-desc_aside_try_to_close_unclosed_tags">
                <option value="on">' . __('on', 'dzsvg') . '</option>
                <option value="off">' . __('off', 'dzsvg') . '</option>
                </select>
            <div class="sidenote" style="">' . __('video descriptions will be retrieved as html rich content, some may be broken after shortage. attempt to repair this by setting this to <strong>on</strong>', 'dzsvg') . '</div>
</div>





</div>
</div>


        

<div class="dzstoggle toggle1" rel="">
<div class="toggle-title" style="">' . __('Outer Parts', 'dzsvg') . '</div>
<div class="toggle-content">
        
        <div class="setting type_all">
            <div class="setting-label">' . __('Second Con', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-enable_secondcon">
                <option value="off">' . __('off', 'dzsvg') . '</option>
                <option value="on">' . __('on', 'dzsvg') . '</option>
                </select>
                <div class="sidenote" style="">' . __('enable linking to a slider with titles and descriptions as seen in the demos. to insert the container in your page use this shortcode [dzsvg_secondcon id="theidofthegallery" extraclasses=""]', 'dzsvg') . '</div>
            
        </div>
        
        <div class="setting type_all">
            <div class="setting-label">' . __('Outer Navigation', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-enable_outernav">
                <option value="off">' . __('off', 'dzsvg') . '</option>
                <option value="on">' . __('on', 'dzsvg') . '</option>
                </select>
                <div class="sidenote" style="">' . __('enable linking to a outside navigation [dzsvg_outernav id="theidofthegallery" skin="oasis" extraclasses="" layout="layout-one-third" thumbs_per_page="9" ]', 'dzsvg') . '</div>
            
        </div>
        <div class="setting type_all">
            <div class="setting-label">' . __('Outer Navigation, Show Video Author', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-enable_outernav_video_author">
                <option value="off">' . __('off', 'dzsvg') . '</option>
                <option value="on">' . __('on', 'dzsvg') . '</option>
                </select>
                <div class="sidenote" style="">' . __('show the video author for YouTube channels and playlists', 'dzsvg') . '</div>
            
        </div>
        <div class="setting type_all">
            <div class="setting-label">' . __('Outer Navigation, Show Video Date', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-enable_outernav_video_date">
                <option value="off">' . __('off', 'dzsvg') . '</option>
                <option value="on">' . __('on', 'dzsvg') . '</option>
                </select>
                <div class="sidenote" style="">' . __('published date', 'dzsvg') . '</div>
            
        </div>


</div>
</div>




<div class="dzstoggle toggle1" rel="">
<div class="toggle-title" style="">' . __('Misc Options', 'dzsvg') . '</div>
<div class="toggle-content">


        <div class="setting type_all">
            <div class="setting-label">' . __('Play Order', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-playorder">
                <option value="ASC">' . __('normal', 'dzsvg') . '</option>
                <option value="DESC">' . __('reverse', 'dzsvg') . '</option>
            </select>
            <div class="sidenote" style="">' . __('set to reverse for example to play the latest episode in a series first ... or for RTL configurations', 'dzsvg') . '</div>
        </div>
        
        
        <div class="setting type_all">
            <div class="setting-label">' . __('Initialize On', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-init_on">
                <option value="init">' . __('Init', 'dzsvg') . '</option>
                <option value="scroll">' . __('Scroll', 'dzsvg') . '</option>
            </select>
            <div class="sidenote" style="">' . __('init - at start // scroll - when visible in page view', 'dzsvg') . '</div>
        </div>

        <div class="setting type_all">
            <div class="setting-label">' . __('Ids Point to Source', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-ids_point_to_source">
                <option value="off">' . __('off', 'dzsvg') . '</option>
                <option value="on">' . __('on', 'dzsvg') . '</option>
                </select>
                <div class="sidenote" style="">' . __('the id of the video players can point to the source file used', 'dzsvg') . '</div>

        </div>

        <div class="setting type_all">
            <div class="setting-label">' . __('Autoplay on Mobiles', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-autoplayWithVideoMuted">
                <option value="off">' . __('off', 'dzsvg') . '</option>
                <option value="on">' . __('on', 'dzsvg') . '</option>
                </select>
                <div class="sidenote" style="">' . __('normally, videos cannot autoplay on mobiles to save bandwidth, but with newest standards videos are allowed to play, but muted - if your video has no sound you can choose this option to autoplay on mobiles', 'dzsvg') . '</div>

        </div>



</div>
</div>

';


    if ($dzsvg->mainoptions['enable_developer_options'] == 'on') {

      $fout .= '


        <div class="setting type_all">
            <div class="setting-label">' . __('Javascript on Playlist End', 'dzsvg') . '</div>
            
            ' . DZSHelpers::generate_input_textarea('0-settings-action_playlist_end', array(
          'class' => 'textinput mainsetting',
        )) . '
                <div class="sidenote" style="">' . __('write a javascript function that happens on playlist end ', 'dzsvg') . '</div>

        </div>
    
';
    }


    $fout .= '
        
        
        </div><!--end settings con-->
        <div class="modes-con">
        
        <div class="setting mode_ytuserchannel">
            <div class="setting_label">' . __('YouTube User', 'dzsvg') . '</div>
            <input type="text" class="short textinput mainsetting" name="0-settings-youtubefeed_user" value=""/>
        </div>
	<div class="setting mode_ytplaylist">
            <div class="setting_label">' . __('YouTube Playlist', 'dzsvg') . '
                <div class="info-con">
                <div class="info-icon"></div>
                <div class="sidenote">' . __('You need to set the playlist ID there not the playlist Name. For example for this playlist http:' . '/' . '' . '/' . 'www.youtube.com/my_playlists?p=PL08BACDB761A0C52A the id is 08BACDB761A0C52A. Remember that if you have the characters PL at the beggining of the ID they should not be included here.', 'dzsvg') . '</div>
                </div>
</div>
                
                <input type="text" class="short textinput mainsetting" name="0-settings-ytplaylist_source" value=""/>
        </div>
	<div class="setting mode_ytkeywords">
            <div class="setting_label">' . __('YouTube Keywords', 'dzsvg') . '
                <div class="info-con">
                <div class="info-icon"></div>
                <div class="sidenote">' . '' . '</div>
                </div>
                </div>

                <input type="text" class="short textinput mainsetting" name="0-settings-ytkeywords_source" value=""/>
        </div>
        <div class="setting type_all mode_ytuserchannel mode_ytplaylist mode_ytkeywords">
            <div class="setting-label">' . __('YouTube Max Videos', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-youtubefeed_maxvideos" value="50"/>
            <div class="sidenote">' . __('input a limit of videos here ( can be a maximum of 50 ) if you have more then 50 videos in your stream, just input "<strong>all</strong>" in this field ( without quotes ) ', 'dzsvg') . '</div>
        </div>';


    if (ini_get('allow_url_fopen') || function_exists('curl_version')) {
    } else {

      $fout .= '<div class="setting type_all mode_ytuserchannel mode_ytplaylist mode_ytkeywords">
            <div class="setting-label warning">' . __('warning - curl nor allow_furl_open enabled on your server ..  / ask your server to enable any of these', 'dzsvg') . '</div>
        </div>';
    }


    $fout .= '<div class="setting type_all mode_vmuserchannel">
            <div class="setting_label">' . __('Vimeo User ID', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-vimeofeed_user" value=""/>
            <div class="sidenote">' . sprintf(__('be sure this to be your user id . For example mine is user5137664 even if my name is digitalzoomstudio  %s  you get that by checking your profile link.', 'dzsvg'), '- https://vimeo.com/user5137664 -') . '</div>
        </div>
        
        <div class="setting type_all mode_vmchannel">
            <div class="setting_label">' . __('Vimeo Channel ID', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-vimeofeed_channel" value=""/>
            <div class="sidenote">' . __('be sure all videos are allowed to be embedded . Channel example for  – https://vimeo.com/channels/636900 - is <strong>636900</strong>.', 'dzsvg') . '</div>
        </div>
        
        <div class="setting type_all mode_vmalbum">
            <div class="setting_label">' . __('Vimeo Album ID', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-vimeofeed_vmalbum" value=""/>
            <div class="sidenote">' . __('be sure all videos are allowed to be embedded . Channel example for  – https://vimeo.com/album/2633720 - is <strong>2633720</strong>.', 'dzsvg') . '</div>
        </div>


        <div class="setting type_all mode_vmuserchannel mode_vmchannel mode_vmalbum">
            <div class="setting-label">' . __('Vimeo Max Videos', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-vimeo_maxvideos" value="25"/>
            <div class="sidenote">' . __('input a limit of videos here - note that if you have not set a Vimeo API oAuth login <a href="admin.php?page=' . DZSVG_PAGENAME_MAINOPTIONS . '">here</a> /  the limit will be 20 videos with no api setup', 'dzsvg') . '</div>
        </div>
        
        <div class="setting type_all mode_facebook">
            <div class="setting_label">' . __('Facebook url', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-facebook_url" value=""/>
            <div class="sidenote">' . __('input full facebook page url', 'dzsvg') . '</div>
        </div>


        <div class="setting type_all mode_facebook">
            <div class="setting-label">' . __('Facebook Max Videos', 'dzsvg') . '</div>
            <input type="text" class="textinput mainsetting" name="0-settings-vimeo_maxvideos" value="25"/>
            <div class="sidenote">' . __('input a limit of videos here - note that if you have not set a Facebook API oAuth login ', 'dzsvg') . '</div>
        </div>


        <div class="setting type_all mode_vmuserchannel mode_vmchannel mode_vmalbum">
            <div class="setting-label">' . __('Vimeo Sort Mode', 'dzsvg') . '</div>
            <select class="textinput mainsetting styleme" name="0-settings-vimeo_sort">
                <option value="default">' . __("Default", 'dzsvg') . '</option>
                <option value="manual">' . __('Manual', 'dzsvg') . '</option>
                <option value="date">' . __('By Date', 'dzsvg') . '</option>
                <option value="alphabetic">' . __('Alphabetic', 'dzsvg') . '</option>
                <option value="plays">' . __('Number plays', 'dzsvg') . '</option>
                </select>
            <div class="sidenote">' . __('Default means as served by vimeo by default / Manual means as sorted in album settings', 'dzsvg') . '</div>
        </div>
        
</div>
        <div class="master-items-con mode_normal">
        <div class="items-con "></div>
        <a href="#" class="add-item"></a>
        </div><!--end master-items-con-->
        <div class="clear"></div>
        </div>';

    return $fout;
  }

  /**
   * [deprecated]
   * @param $start_nr
   * @param $end_nr
   * @return string
   */
  public static function playlist_parseItemsForAlternateWall($start_nr, $end_nr) {
    $fout = '';

    for ($i = $start_nr; $i < $end_nr; $i++) {
      if (!isset($its[$i]['type'])) {
        continue;
      }
      $islastonrow = false;
      if ($i % 4 == 3) {
        $islastonrow = true;
      }
      $itemclass = 'item';
      if ($islastonrow == true) {
        $itemclass .= ' last';
      }
      $fout .= '<div class="' . $itemclass . '">';

      $fout .= '<a class="zoombox" data-type="video" data-videotype="' . $its[$i]['type'] . '" data-src="' . DZSVideoGalleryHelper::sanitize_for_html_attribute_value_no_spaces($its[$i]['source']) . '"><img width="100%" height="100%" class="item-image" src="';
      if ($its[$i]['thethumb'] != '') $fout .= $its[$i]['thethumb']; else {
        if ($its[$i]['type'] == "youtube") {
          $fout .= 'https://img.youtube.com/vi/' . $its[$i]['source'] . '/0.jpg';
          $its[$i]['thethumb'] = 'https://img.youtube.com/vi/' . $its[$i]['source'] . '/0.jpg';
        }
      }
      $fout .= '"/></a>';
      $fout .= '<h4>' . $its[$i]['title'] . '</h4>';
      $fout .= '</div>';
      if ($islastonrow) {
        $fout .= '<div class="clear"></div>';
      }
    }

    return $fout;

  }

  public static function vimeo_detectIdFromUrl($arg) {

    $fout = $arg;

    if (strpos($arg, '/') !== false) {
      $argarr = explode('/', $arg);
      $fout = $argarr[count($argarr) - 1];
    }
    return $fout;
  }

  /**
   * @param array $argarr
   * @param array $addrArray
   * @return array
   */
  public static function sanitize_config_to_gutenberg_register_block_type($argarr, &$addrArray) {

    $foutarr = array();
    foreach ($argarr as $key => $arr) {

      $finalkey = $key;

      $default = '';

      if (isset($arr['default'])) {
        $default = $arr['default'];
      }


      if ($addrArray) {
        $addrArray[$finalkey] = array(
          'type' => 'string',
          'default' => $default,
        );
      } else {

        $foutarr[$finalkey] = array(
          'type' => 'string',
          'default' => $default,
        );
      }
    }
    return $foutarr;

  }

  /**
   * file name is enough, the folder will be auto selected based on dzsvg assets library path
   * @param $fileUrl
   * @return string
   */
  static function admin_documentationGetAsset($fileUrl) {
    if (strpos($fileUrl, 'https://') !== false) {
      return $fileUrl;
    }
    return '';
  }

  static function admin_generateTooltip($tooltip) {

    // -- tooltip
    ob_start();
    ?> <span class="dzstooltip-con js for-hover for-click "><span class="tooltip-indicator"><span
        class="tooltip-info-indicator"><span
          class="tooltip-info-indicator--i">i</span></span></span><span
      class="dzstooltip  talign-center arrow-bottom style-rounded color-dark-light  dims-set transition-slidedown "
      style="width: 280px;">

                  <span class="dzstooltip--inner"><?php
                    if (isset($tooltip['image_url']) && $tooltip['image_url']) {
                      ?>
                      <span class="divimage negative-margin-top"
                            style="padding-top: 52.625%; background-image: url(<?php echo $tooltip['image_url']; ?>); "></span>
                      <?php
                    }
                    ?>
            <span class="paragraph"><?php echo $tooltip['description'] ?></span>

            </span> </span></span><?php

    return ob_get_clean();
  }

  /**
   * @param array $config_main_options
   * @param string $category
   * @param null $mainOptions
   * @return string
   */
  static function generateOptionsFromConfigForMainOptions($config_main_options, $category = 'main', $mainOptions = null) {


    $fout = '';
    foreach ($config_main_options as $key => $main_option) {
      if ($main_option['category'] !== $category) {
        continue;
      }

      $lab = $key;


      $val = '';

      if (isset($main_option['default']) && $main_option['default']) {
        $val = $main_option['default'];
      }

      if (isset($mainOptions[$lab]) && $mainOptions[$lab]) {
        $val = $mainOptions[$lab];
      }


      $fout .= '<div class="setting">';
      $fout .= '<div class="setting-label"><div class="setting-label--text">' . $main_option['title'] . '</div>';


      if (isset($main_option['tooltip']) && $main_option['tooltip']) {
        // todo: move in helper
        $fout .= ClassDzsvgHelpers::admin_generateTooltip($main_option['tooltip']);
      }

      $fout .= '</div>';

      $argsForInput = array(
        'id' => $lab,
        'val' => '',
        'class' => ' ',
        'seekval' => $val,
      );
      if (isset($main_option['extraAttr'])) {
        $argsForInput['extraattr'] = $main_option['extraAttr'];

      }

      if ($main_option['type'] == 'textarea') {
        $fout .= DZSHelpers::generate_input_textarea($lab, $argsForInput);
      }
      if ($main_option['type'] == 'text') {
        $fout .= DZSHelpers::generate_input_text($lab, $argsForInput);
      }
      if ($main_option['type'] == 'select') {
        $argsForInput['class'] = 'dzs-style-me skin-beige';
        $argsForInput['options'] = $main_option['choices'];
        $fout .= DZSHelpers::generate_select($lab, $argsForInput);
      }
      if ($main_option['type'] == 'checkbox') {

        $fout .= DZSHelpers::generate_input_text($lab, array('id' => $lab, 'val' => 'off', 'input_type' => 'hidden'));
        $fout .= '<div class="dzscheckbox skin-nova">';
        $fout .= DZSHelpers::generate_input_checkbox($lab, array('id' => $lab, 'val' => 'on', 'seekval' => $val));
        $fout .= '<label for="' . $lab . '"></label>';
        $fout .= '</div>';
      }
      if (isset($main_option['sidenote']) && $main_option['sidenote']) {
        $fout .= '<div class="sidenote">' . $main_option['sidenote'] . '</div>';
      }

      $fout .= '</div>';


    }
    return $fout;

  }


  public static function generate_embedCode($pargs = array()) {

    $margs = array(
      'extra_classes' => 'search-align-right',
      'called_from' => 'default',
      'type' => 'player', // -- only player for now
      'player_margs' => '', // -- non encoded
      'extra_code' => '', // -- non encoded
      'enc_margs' => '', // -- encoded
      'extra_embed_code' => '', // -- extra code to be added at the end of the embed code
    );

    if (!is_array($pargs)) {
      $pargs = array();
    }
    $margs = array_merge($margs, $pargs);
    $embed_code = '';


    if ($margs['enc_margs'] == '' && $margs['player_margs']) {
      $margs['enc_margs'] = base64_encode(json_encode($margs['player_margs']));
    }


    $extra_code = '';
    $embed_code = '<div style="width: 100%; padding-top: 67.5%; position: relative;"><iframe src=\'' . site_url() . '?action=embed_dzsvg&type=' . $margs['type'] . '&margs=' . urlencode($margs['enc_margs']) . $margs['extra_code'] . '\'  width="100%" style="position:absolute; top:0; left:0; width: 100%; height: 100%;" scrolling="no" frameborder="0" allowfullscreen allow></iframe></div>';
    $embed_code = str_replace("'", '"', $embed_code);

    return $embed_code;

  }

  public static function facebook_maybeStartSession() {
    global $dzsvg;

    $app_id = $dzsvg->mainoptions['facebook_app_id'];
    $app_secret = $dzsvg->mainoptions['facebook_app_secret'];


    if ($app_id && $app_secret) {


      if (isset($_SESSION)) {
        // -- set cookies for session for some reason
        foreach ($_SESSION as $k => $v) {
          if (strpos($k, "FBRLH_") !== FALSE) {
            if (!setcookie($k, $v)) {
              //what??
            } else {
              $_COOKIE[$k] = $v;
            }
          }
        }
      }


    }
  }

  public static function generateSingleVideoPagePlayer($targetPost, $pargs = array()) {

    // -- for single custom post type dzsvideo

    global $dzsvg, $current_user;
    $targetPost_id = $targetPost->ID;

    $fout = '';


    $margs = array('disable_meta' => 'auto',
      'called_from' => 'default',
    );


    $margs = array_merge($margs, $pargs);


    $dzsvg->sliders_index++;
    $dzsvg->front_scripts();

    $target_playlist = '';
    $target_playlist_startnr = 0;

    //---playlist setup

    if (isset($_GET['dzsvp_user']) && isset($_GET['dzsvp_playlist'])) {
      $target_user_id = $_GET['dzsvp_user'];

      $target_playlists = get_user_meta($target_user_id, 'dzsvp_playlists', true);
      if (is_array($target_playlists)) {
        $target_playlists = json_encode($target_playlists);
      }
      $target_playlists = json_decode($target_playlists, true);


      foreach ($target_playlists as $pl) {
        if ($pl['name'] == $_GET['dzsvp_playlist']) {
          $target_playlist = $pl;
          break;
        }
      }
    }


    if ($margs['disable_meta'] != 'on') {
      if ($dzsvg->mainoptions['dzsvp_tab_share_content'] != 'on' || $dzsvg->mainoptions['dzsvp_enable_tab_playlist'] == 'on') {
      }
    }


    wp_enqueue_style('dzstabsandaccordions', DZSVG_URL . 'libs/dzstabsandaccordions/dzstabsandaccordions.css');
    wp_enqueue_script('dzstabsandaccordions', DZSVG_URL . "libs/dzstabsandaccordions/dzstabsandaccordions.js", array('jquery'));


    wp_enqueue_style('fontawesome', 'https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css');


    $featured_media = get_post_meta($targetPost_id, 'dzsvg_meta_featured_media', true);


    if ($featured_media == '') {

      // -- deprecated
      $featured_media = get_post_meta($targetPost_id, 'dzsvg_meta_featured_media', true);
    }


    $type = 'video';

    if (get_post_meta($targetPost_id, 'dzsvg_meta_item_type', true) != '') {
      $type = get_post_meta($targetPost_id, 'dzsvg_meta_item_type', true);
    }

    if ($type == '') {

      // -- deprecated
      $featured_media = get_post_meta($targetPost_id, 'dzsvp_item_type', true);
    }

    $i = 0;
    $vpconfig_k = 0;
    $vpconfig_id = '';


    $vpsettingsdefault = array('id' => 'default', 'skin_html5vp' => 'skin_aurora',
      'defaultvolume' => '',
      'youtube_sdquality' => 'small',
      'youtube_hdquality' => 'hd720',
      'youtube_defaultquality' => 'hd',
      'yt_customskin' => 'on',
      'vimeo_byline' => '0',
      'vimeo_portrait' => '0',
      'vimeo_color' => '',
      'settings_video_overlay' => 'off',
      'settings_disable_mouse_out' => 'off',
    );
    $vpsettings = array();


    $vpconfig_id = $dzsvg->mainoptions['dzsvp_video_config'];

    if ($vpconfig_id != '') {
      for ($i = 0; $i < count($dzsvg->mainvpconfigs); $i++) {
        if ((isset($vpconfig_id)) && ($vpconfig_id == $dzsvg->mainvpconfigs[$i]['settings']['id'])) $vpconfig_k = $i;
      }
      $vpsettings = $dzsvg->mainvpconfigs[$vpconfig_k];


      if (!isset($vpsettings['settings']) || $vpsettings['settings'] == '') {
        $vpsettings['settings'] = array();
      }
    }

    if (!isset($vpsettings['settings']) || (isset($vpsettings['settings']) && !is_array($vpsettings['settings']))) {
      $vpsettings['settings'] = array();
    }

    $vpsettings['settings'] = array_merge($vpsettingsdefault, $vpsettings['settings']);


    $skin_vp = 'skin_aurora';
    if ($vpsettings['settings']['skin_html5vp'] == 'skin_custom') {
      $skin_vp = 'skin_pro';
    } else {

      if ($vpsettings['settings']['skin_html5vp'] == 'skin_custom_aurora') {
        $skin_vp = 'skin_aurora';

      } else {

        $skin_vp = $vpsettings['settings']['skin_html5vp'];
      }
    }


    if ($vpsettings['settings']['skin_html5vp'] == 'skin_custom') {


      $selector = '#mainvpfromvp' . $dzsvg->sliders_index;


      $dzsvg->str_footer_css .= '#mainvpfromvp' . $dzsvg->sliders_index . ' { background-color:' . $dzsvg->mainoptions_dc['background'] . ';} ';
      $dzsvg->str_footer_css .= $selector . ' .cover-image > .the-div-image { background-color:' . $dzsvg->mainoptions_dc['background'] . ';} ';
      $dzsvg->str_footer_css .= '#mainvpfromvp' . $dzsvg->sliders_index . ' .background{ background-color:' . $dzsvg->mainoptions_dc['controls_background'] . ';} ';
      $dzsvg->str_footer_css .= '#mainvpfromvp' . $dzsvg->sliders_index . ' .scrub-bg{ background-color:' . $dzsvg->mainoptions_dc['scrub_background'] . ';} ';
      $dzsvg->str_footer_css .= '#mainvpfromvp' . $dzsvg->sliders_index . ' .scrub-buffer{ background-color:' . $dzsvg->mainoptions_dc['scrub_buffer'] . ';} ';
      $dzsvg->str_footer_css .= '#mainvpfromvp' . $dzsvg->sliders_index . ' .playSimple{ border-left-color:' . $dzsvg->mainoptions_dc['controls_color'] . ';} #mainvpfromvp' . $dzsvg->sliders_index . ' .stopSimple .pause-part-1{ background-color: ' . $dzsvg->mainoptions_dc['controls_color'] . '; } #mainvpfromvp' . $dzsvg->sliders_index . ' .stopSimple .pause-part-2{ background-color: ' . $dzsvg->mainoptions_dc['controls_color'] . '; } #mainvpfromvp' . $dzsvg->sliders_index . ' .volumeicon{ background: ' . $dzsvg->mainoptions_dc['controls_color'] . '; } #mainvpfromvp' . $dzsvg->sliders_index . ' .volumeicon:before{ border-right-color: ' . $dzsvg->mainoptions_dc['controls_color'] . '; } #mainvpfromvp' . $dzsvg->sliders_index . ' .volume_static{ background: ' . $dzsvg->mainoptions_dc['controls_color'] . '; } #mainvpfromvp' . $dzsvg->sliders_index . ' .hdbutton-con .hdbutton-normal{ color: ' . $dzsvg->mainoptions_dc['controls_color'] . '; } #mainvpfromvp' . $dzsvg->sliders_index . ' .total-timetext{ color: ' . $dzsvg->mainoptions_dc['controls_color'] . '; } ';
      $dzsvg->str_footer_css .= '#mainvpfromvp' . $dzsvg->sliders_index . ' .playSimple:hover{ border-left-color: ' . $dzsvg->mainoptions_dc['controls_hover_color'] . '; } #mainvpfromvp' . $dzsvg->sliders_index . ' .stopSimple:hover .pause-part-1{ background-color: ' . $dzsvg->mainoptions_dc['controls_hover_color'] . '; } #mainvpfromvp' . $dzsvg->sliders_index . ' .stopSimple:hover .pause-part-2{ background-color: ' . $dzsvg->mainoptions_dc['controls_hover_color'] . '; } #mainvpfromvp' . $dzsvg->sliders_index . ' .volumeicon:hover{ background: ' . $dzsvg->mainoptions_dc['controls_hover_color'] . '; } #mainvpfromvp' . $dzsvg->sliders_index . ' .volumeicon:hover:before{ border-right-color: ' . $dzsvg->mainoptions_dc['controls_hover_color'] . '; } ';
      $dzsvg->str_footer_css .= '#mainvpfromvp' . $dzsvg->sliders_index . ' .volume_active{ background-color: ' . $dzsvg->mainoptions_dc['controls_highlight_color'] . '; } #mainvpfromvp' . $dzsvg->sliders_index . ' .scrub{ background-color: ' . $dzsvg->mainoptions_dc['controls_highlight_color'] . '; } #mainvpfromvp' . $dzsvg->sliders_index . ' .hdbutton-con .hdbutton-hover{ color: ' . $dzsvg->mainoptions_dc['controls_highlight_color'] . '; } ';
      $dzsvg->str_footer_css .= '#mainvpfromvp' . $dzsvg->sliders_index . ' .curr-timetext{ color: ' . $dzsvg->mainoptions_dc['timetext_curr_color'] . '; } ';

    }


    $target_playlist = '';
    $target_playlist_startnr = 0;

    //---playlist setup

    if (isset($_GET['dzsvp_user']) && isset($_GET['dzsvp_playlist'])) {
      $target_user_id = $_GET['dzsvp_user'];

      $target_playlists = get_user_meta($target_user_id, 'dzsvp_playlists', true);
      if (is_array($target_playlists)) {
        $target_playlists = json_encode($target_playlists);
      }
      $target_playlists = json_decode($target_playlists, true);


      foreach ($target_playlists as $pl) {
        if ($pl['name'] == $_GET['dzsvp_playlist']) {
          $target_playlist = $pl;
          break;
        }
      }
    }


    $fout .= '<div class="mainvp-con dzsvg--single-video-page--con">';


    if ($target_playlist) {


      wp_enqueue_style('dzs.scroller', DZSVG_URL . 'assets/dzsscroller/scroller.css');
      wp_enqueue_script('dzs.scroller', DZSVG_URL . 'assets/dzsscroller/scroller.js');

      $fout .= '<div class="videogallery-con currGallery" style="width:275px; height:300px; float:right; padding-top: 0; padding-bottom: 0;">
<div class="dzsvg-preloader"></div>
<div class="vg-playlist videogallery skin_default" style="width:275px; height:300px;">';


      $i5 = 0;

      global $post;
      foreach ($target_playlist['items'] as $targetPlaylistItemId) {
        $postItem = get_post($targetPlaylistItemId);

        $playlistLink = get_permalink($targetPlaylistItemId);

        $playlistLink = add_query_arg('dzsvp_user', $_GET['dzsvp_user'], $playlistLink);
        $playlistLink = add_query_arg('dzsvp_playlist', $_GET['dzsvp_playlist'], $playlistLink);


        if ($post->ID == $targetPlaylistItemId) {
          $target_playlist_startnr = $i5;
        }

        $stringFeaturedImage = '';

        $imgsrc = wp_get_attachment_image_src(get_post_thumbnail_id($targetPlaylistItemId), "full");
        if ($imgsrc) {

          if (is_array($imgsrc)) {
            $imgsrc = $imgsrc[0];
          }
        } else {
          if (get_post_meta($targetPost_id, 'dzsvg_meta_thumb', true)) {
            $imgsrc = get_post_meta($targetPlaylistItemId, 'dzsvg_meta_thumb', true);
          } else {
            if (get_post_meta($targetPost_id, 'dzsvp_thumb', true)) {
              $imgsrc = get_post_meta($targetPlaylistItemId, 'dzsvp_thumb', true);
            }
          }
        }


        if (get_post_meta($targetPlaylistItemId, 'dzsvp_featured_media', true)) {

          update_post_meta($targetPlaylistItemId, 'dzsvg_meta_featured_media', get_post_meta($targetPlaylistItemId, 'dzsvp_featured_media', true));
          update_post_meta($targetPlaylistItemId, 'dzsvp_featured_media', '');
        }
        if (get_post_meta($targetPlaylistItemId, 'dzsvp_item_type', true)) {

          update_post_meta($targetPlaylistItemId, 'dzsvg_meta_item_type', get_post_meta($targetPlaylistItemId, 'dzsvp_item_type', true));
          update_post_meta($targetPlaylistItemId, 'dzsvp_item_type', '');
        }

        if ($imgsrc) {
          $stringFeaturedImage = '<img data-imgsrc="' . $imgsrc . '" class="imgblock"  alt="' . $postItem->post_title . '""/>';
        } else {

          if (get_post_meta($targetPlaylistItemId, 'dzsvg_meta_item_type', true) == 'youtube') {
            $stringFeaturedImage = '<img data-imgsrc="https://img.youtube.com/vi/' . get_post_meta($targetPlaylistItemId, 'dzsvg_meta_featured_media', true) . '/0.jpg" class="imgblock"/>';
          }
        }


        $fout .= '<div class="vplayer-tobe" data-videoTitle="' . $postItem->post_title . '" data-type="link" data-sourcevp="' . $playlistLink . '" data-postid="' . $targetPlaylistItemId . '" data-player-id="' . $targetPlaylistItemId . '"';

        if ($dzsvg->mainoptions['videopage_resize_proportional'] == 'on') {
          $fout .= ' data-responsive_ratio="detect"';
        }

        $fout .= '>
<div class="menuDescription">' . $stringFeaturedImage . '
    <div class="the-title">' . $postItem->post_title . '</div> ' . $postItem->post_content . '
</div>
</div>';
        $i5++;
      }


      $fout .= '</div></div>';
      $fout .= '<div class="history-video-element" style="overflow:hidden;">';
    }

    // -- single audio player page
    $fout .= '<div id="mainvpfromvp' . $dzsvg->sliders_index . '"   data-player-id="' . $targetPost->ID . '" data-postid="' . $targetPost->ID . '" class="vplayer-tobe from-parse-videoitem" data-videoTitle="' . $targetPost->post_title . '" data-type="' . $type . '" data-src="' . DZSVideoGalleryHelper::sanitize_for_html_attribute_value_no_spaces($featured_media) . '"';


    $aux = 'dzsvg_meta_ad_array';
    if (get_post_meta($targetPost->ID, $aux, true)) {
      $fout .= ' data-ad-array' . '' . '=\'' . (get_post_meta($targetPost->ID, $aux, true)) . '\'';

    }


    $aux = 'dzsvg_meta_play_from';
    if (get_post_meta($targetPost->ID, $aux, true)) {
      $fout .= ' data-playfrom' . '' . '=\'' . (get_post_meta($targetPost->ID, $aux, true)) . '\'';

    }


    $fout .= '>';


    $aux = 'dzsvg_meta_subtitle';

    if (get_post_meta($targetPost->ID, $aux, true)) {
      $fil = DZSHelpers::get_contents(get_post_meta($targetPost->ID, $aux, true));
      $fout .= '<div class="subtitles-con-input">' . $fil . '</div>';
    }


    $fout .= '</div>';


    if ($target_playlist) {

      $fout .= '</div>'; // end .history-video-element
    }


    if ($dzsvg->mainoptions['analytics_enable'] == 'on') {

      if (current_user_can('manage_options')) {

        $fout .= '<div class="extra-btns-con">';
        $fout .= '<span class="btn-zoomsounds stats-btn" data-playerid="' . $targetPost_id . '"><span class="the-icon"><i class="fa fa-tachometer" aria-hidden="true"></i></span><span class="btn-label">' . esc_html__('Stats', 'dzsvg') . '</span></span>';
        $fout .= '</div>';


        ClassDzsvgHelpers::enqueueDzsVgShowcase();
      }


    }


    if ($margs['disable_meta'] != 'on') {
      include_once(DZSVG_PATH.'configs/svg-assets.php');
      if ($dzsvg->mainoptions['dzsvp_enable_likes'] == 'on' || $dzsvg->mainoptions['dzsvp_enable_ratings'] == 'on' || $dzsvg->mainoptions['dzsvp_enable_viewcount'] == 'on' || $dzsvg->mainoptions['dzsvp_enable_likescount'] == 'on' || $dzsvg->mainoptions['dzsvp_enable_ratingscount'] == 'on') {

        $nr_views = 0;
        $fout .= '<div class="extra-html extra-html--videoitem">';
        if ($dzsvg->mainoptions['dzsvp_enable_likes'] == 'on') {


          $fout .= '<span class=" btn-zoomsounds btn-like';

          if (isset($_COOKIE['dzsvp_likesubmitted-' . $targetPost_id]) && $_COOKIE['dzsvp_likesubmitted-' . $targetPost_id] == '1') {
            $fout .= ' active';
          }

          $fout .= '"><span class="the-icon"><svg xmlns:svg="https://www.w3.org/2000/svg" xmlns="https://www.w3.org/2000/svg" version="1.0" width="15" height="15" viewBox="0 0 645 700" id="svg2"> <defs id="defs4"></defs> <g id="layer1"> <path d="M 297.29747,550.86823 C 283.52243,535.43191 249.1268,505.33855 220.86277,483.99412 C 137.11867,420.75228 125.72108,411.5999 91.719238,380.29088 C 29.03471,322.57071 2.413622,264.58086 2.5048478,185.95124 C 2.5493594,147.56739 5.1656152,132.77929 15.914734,110.15398 C 34.151433,71.768267 61.014996,43.244667 95.360052,25.799457 C 119.68545,13.443675 131.6827,7.9542046 172.30448,7.7296236 C 214.79777,7.4947896 223.74311,12.449347 248.73919,26.181459 C 279.1637,42.895777 310.47909,78.617167 316.95242,103.99205 L 320.95052,119.66445 L 330.81015,98.079942 C 386.52632,-23.892986 564.40851,-22.06811 626.31244,101.11153 C 645.95011,140.18758 648.10608,223.6247 630.69256,270.6244 C 607.97729,331.93377 565.31255,378.67493 466.68622,450.30098 C 402.0054,497.27462 328.80148,568.34684 323.70555,578.32901 C 317.79007,589.91654 323.42339,580.14491 297.29747,550.86823 z" id="path2417" style=""></path> <g transform="translate(129.28571,-64.285714)" id="g2221"></g> </g> </svg> </span><span class="the-label hide-on-active">' . __("Like") . '</span><span class="the-label show-on-active">' . __("Liked") . '</span></span>';

        }
        if ($dzsvg->mainoptions['dzsvp_enable_ratings'] == 'on') {

          $playerid = '';


          $aux = get_post_meta($targetPost->ID, '_dzsvp_rate_index', true);

          // -- 1 to 5
          if ($aux == '') {
            $aux = 0;
          } else {
            $aux = floatval($aux) / 5;
          }
          if ($aux > 5) {
            $aux = 5;
          }

          $perc = floatval(($aux) * 100);


          $fout .= '<div class="star-rating-con" data-initial-rating-index="' . $aux . '">';


          $arte_stars = '<span class="rating-bg"><span class="rating-inner">{{starssvg}}</span></span>
 <span class="rating-prog" style="width: ' . $perc . '%;"><span class="rating-inner">{{starssvg}}</span></span>';


          $arte_stars = str_replace('{{starssvg}}', DZSVG_SVG_STAR . DZSVG_SVG_STAR . DZSVG_SVG_STAR . DZSVG_SVG_STAR . DZSVG_SVG_STAR, $arte_stars);

          $fout .= $arte_stars;
          $fout .= '</div>';
        }
        if ($dzsvg->mainoptions['videopage_show_views'] == 'on') {
          $nr_views = DzsvgAjax::mysql_get_views($targetPost_id);


          $fout .= '<div class="counter-hits"><i class="fa fa-eye"></i>  <span class="the-label"> <span class="the-number">' . $nr_views . '</span> <span class="the-label-text">' . __("views") . '</span></span></div>';

        }
        if ($dzsvg->mainoptions['dzsvp_enable_likescount'] == 'on') {
          $nr_likes = '';
          if (get_post_meta($targetPost_id, '_dzsvp_likes', true) == '') {
            $nr_likes .= '0';
          } else {
            $nr_likes .= get_post_meta($targetPost_id, '_dzsvp_likes', true);
          }


          $fout .= '<div class="counter-likes"><i class="fa fa-heart"></i>  <span class="the-label"> <span class="the-number">' . $nr_likes . '</span> <span class="the-label-text">' . __("likes") . '</span></span></div>';
        }
        if ($dzsvg->mainoptions['dzsvp_enable_ratingscount'] == 'on') {
          $fout .= '<div class="counter-rates"><span class="the-number">';

          $nr_rates = 0;


          if (get_post_meta($targetPost_id, '_dzsvp_rate_nr', true)) {
            $nr_rates = intval(get_post_meta($targetPost_id, '_dzsvp_rate_nr', true));
          }

          $fout .= $nr_rates . '</span> ' . __('ratings', 'dzsvp') . '</div>';
        }
        $fout .= '</div>';

      }

    }


    $fout .= '<script>';


    $dzsvg->mainoptions['advanced_videopage_custom_action_contor_10_secs'] = str_replace('{{postid}}', $targetPost_id, $dzsvg->mainoptions['advanced_videopage_custom_action_contor_10_secs']);
    if (isset($current_user->data) && isset($current_user->data->ID)) {

      $dzsvg->mainoptions['advanced_videopage_custom_action_contor_10_secs'] = str_replace('{{userid}}', $current_user->data->ID, $dzsvg->mainoptions['advanced_videopage_custom_action_contor_10_secs']);
    }


    // TODO: for custom action


    if ($dzsvg->mainoptions['advanced_videopage_custom_action_contor_10_secs']) {
      $fout .= 'window.custom_action_contor_10_secs = function(arg1,arg2){
            ' . $dzsvg->mainoptions['advanced_videopage_custom_action_contor_10_secs'] . '
}; ';
    }


    if ($dzsvg->mainoptions['videopage_autoplay_next'] == 'on') {
      $fout .= '
window.video_page_action_video_end = function(arg){ console.info("video end - ", arg);';


      $args = array('post_type' => 'dzsvideo', 'posts_per_page' => -1, 'orderby' => 'date', 'order' => 'DESC',);


      $query = new WP_Query($args);


      $ind = 0;
      foreach ($query->posts as $por) {


        if ($por->ID == $targetPost_id) {
          $curr_index = $ind;
        }
        $ind++;
      }


      $target_post_id = 0;

      if (isset($query->posts[$curr_index + 1])) {
        $target_post_id = $query->posts[$curr_index + 1];
      }

      if ($dzsvg->mainoptions['videopage_autoplay_next_direction'] == 'reverse') {
        if (isset($query->posts[$curr_index - 1])) {
          $target_post_id = $query->posts[$curr_index - 1];
        } else {
          $target_post_id = 0;
        }
      }


      if ($target_post_id) {
        $fout .= ' window.location.href = "' . get_permalink($target_post_id) . '";';
      }
      $fout .= '};  ';
    }

    if ($margs['disable_meta'] != 'on') {
      if ($dzsvg->mainoptions['dzsvp_enable_ratings'] == 'on') {
        if (isset($_COOKIE['dzsvp_ratesubmitted-' . $targetPost_id])) {
          $fout .= 'window.starrating_alreadyrated="' . $_COOKIE['dzsvp_ratesubmitted-' . $targetPost_id] . '";';
        }
      };
    }

    $fout .= 'jQuery(document).ready(function($){ var videoplayersettings = {
autoplay : "' . $dzsvg->mainoptions['videopage_autoplay'] . '",
cueVideo : "on",
settings_hideControls : "off"
,settings_video_overlay : "' . $vpsettings['settings']['settings_video_overlay'] . '"
,settings_disable_mouse_out : "' . $vpsettings['settings']['settings_disable_mouse_out'] . '"
,design_skin: "' . $skin_vp . '"';


    if ($dzsvg->mainoptions['videopage_resize_proportional'] == 'on') {

      $fout .= '
,responsive_ratio: "detect"';
    }
    if ($dzsvg->mainoptions['videopage_autoplay_next'] == 'on') {

      $fout .= '
,action_video_end: window.video_page_action_video_end';
    }
    if ($dzsvg->mainoptions['advanced_videopage_custom_action_contor_10_secs']) {

      $fout .= '
,action_video_contor_60secs: window.dzsvg_wp_send_contor_60_secs ';
    }

    ClassDzsvgHelpers::enqueuePlayerSkin($skin_vp);


    $fout .= '};';


    if ($dzsvg->mainoptions['analytics_enable'] == 'on') {


      $player_index = ''; // -- (only one)
      $fout .= 'videoplayersettings' . $player_index . '.action_video_view = window.dzsvg_wp_send_view;';

      $fout .= 'videoplayersettings' . $player_index . '.action_video_contor_60secs = window.dzsvg_wp_send_contor_60_secs;';

    }

    $fout .= 'dzsvp_init("#mainvpfromvp' . $dzsvg->sliders_index . '",videoplayersettings);';


    if ($dzsvg->mainoptions['track_views'] == 'on' || $dzsvg->mainoptions['videopage_show_views'] == 'on') {
      if (!isset($_COOKIE['dzsvp_viewsubmitted-' . $targetPost_id])) {
        $fout .= 'var data = {
    action: "dzsvp_submit_view",
    postdata: "1",
    playerid: "' . $targetPost_id . '"
};
setTimeout(function(){
$.ajax({
type: "POST",
url: dzsvg_settings.ajax_url,
data: data,
success: function(response) {
},
error:function(arg){
}
});
},1500); ';

//                    update_post_meta($po_id, '_dzsvp_views', $nr_views);
      };
    }


    if ($margs['disable_meta'] != 'on') {
      ;
    }


    if ($target_playlist) {
      $fout .= 'dzsvg_init(".vg-playlist",{
totalWidth:275
,settings_mode:"normal"
,menuSpace:0
,randomise:"off"
,autoplay :"off"
,cueFirstVideo: "off"
,autoplayNext : "on"
,nav_type: "scroller"
,menuitem_width:275
,menuitem_height:75
,menuitem_space:1
,menu_position:"right"
,transition_type:"fade"
,design_skin: "skin_navtransparent"
,embedCode:""
,shareCode:""
,logo: ""
,responsive: "on"
,design_shadow:"off"
,settings_disableVideo:"on"
,startItem: "' . $target_playlist_startnr . '"
,settings_enableHistory: "off"
,settings_ajax_extraDivs: ""
});';
    }


    $fout .= '});</script>'; // end document ready


    $fout .= '<div class="clearboth"></div>';
    $fout .= '</div><!-- end .mainvp-con -->'; // end mainvp-con


    if ($margs['disable_meta'] != 'on') {
      if (($dzsvg->mainoptions['dzsvp_tab_share_content'] == 'on' || $dzsvg->mainoptions['dzsvp_enable_tab_playlist'] == 'on' || $dzsvg->mainoptions['dzsvp_enable_tab_playlist'] == 'on') && !is_post_type_archive('dzsvideo')) {

        $fout .= '<div class="clearboth"></div>';
        $fout .= '<div class=""></div>
                    <div class="dzs-tabs auto-init dzs-tabs-dzsvp-page skin-default" data-options="{ \'design_tabsposition\' : \'top\'
                ,design_transition: \'slide\'
                ,design_tabswidth: \'default\'
                ,toggle_breakpoint : \'' . $dzsvg->mainoptions['dzsvp_tabs_breakpoint'] . '\'
                 ,toggle_type: \'accordion\'}">';


        $fout .= '';
        $fout .= '<div class="dzs-tab-tobe">
                <div class="tab-menu"><i class="fa fa-info"></i> ' . __('About', 'dzsvp') . '</div>';
        $fout .= '<div class="tab-content">';


        $fout .= do_shortcode($targetPost->post_content);
        $dzsvg->sw_content_added = true;

        $fout .= '</div>';
        $fout .= '</div>'; // -- close .dzs-tab-tobe


        $fout .= '';


        if ($dzsvg->mainoptions['dzsvp_tab_share_content'] != '' || $dzsvg->mainoptions['dzsvp_enable_tab_playlist'] == 'on') {


          // -- we are in video item page

          if ($dzsvg->mainoptions['dzsvp_tab_share_content'] != '') {


            $aux_cont = $dzsvg->mainoptions['dzsvp_tab_share_content'];
            $aux_cont = str_replace('{{currurl}}', urlencode(dzs_curr_url()), $aux_cont);


            $auxembed = '<iframe src="' . DZSVG_URL . 'bridge.php?action=view&dzsvideo=' . $targetPost_id . '" style="width:100%; height:300px; overflow:hidden;" scrolling="no" frameborder="0"></iframe>';

            $aux_cont = str_replace('{{embedcode}}', htmlentities($auxembed), $aux_cont);


            $fout .= '<div class="dzs-tab-tobe">
                            <div class="tab-menu with-tooltip">
                                <i class="fa fa-share"></i> ' . esc_html__('Share', 'dzsvp') . '
                            </div>
                            <div class="tab-content">
                                <br>' . $aux_cont . '
                            </div>
                        </div>';


          }

          ob_start();
          do_action('dzsvg_extra_tabs_videoitem');

          $fout .= ob_get_contents();

          /* perform what you need on $str with str_replace */

          ob_end_clean();

          $fout .= '</div><!-- end .dzs-tabs -->'; //close .dzs-tabs

          $fout .= '<script>
jQuery(document).ready(function($){
dzstaa_init(".dzs-tabs-dzsvp-page",{ \'design_tabsposition\' : \'top\'
                ,design_transition: \'slide\'
                ,design_tabswidth: \'default\'
                ,toggle_breakpoint : \'' . $dzsvg->mainoptions['dzsvp_tabs_breakpoint'] . '\'
                 ,toggle_type: \'accordion\'});
});</script>';


        }
      }
    }


    return $fout;
  }


  /**
   * used in show_shortcode
   * @param $argumentItemOptions
   * @return array
   */
  public static function sanitize_to_gallery_item($argumentItemOptions) {
    // --
    global $dzsvg;


    $itemOptions = (array)$argumentItemOptions;

    $po_id = $itemOptions['ID'];

    if (!isset($itemOptions['post_type'])) {
      error_log('what is wrong with che ? (sanitize_to_gallery_item)' . print_r($itemOptions, true));
      return array();
    }

    if ($itemOptions['post_type'] == 'attachment') {

      $temp = get_attached_media('video', $po_id);

      if (is_array($temp) && count($temp)) {
        $itemOptions['source'] = $temp[0];
      } else {


        $feat_image_url = wp_get_attachment_url($po_id);

        if ($feat_image_url) {


          $itemOptions['source'] = $feat_image_url;
        } else {

          $itemOptions['source'] = $itemOptions['guid'];
        }
      }
    }


    foreach ($dzsvg->options_item_meta as $oim) {


      if ($oim['name'] === 'post_content' || $oim['name'] === 'the_post_content' || $oim['name'] === 'the_post_title') {
        continue;
      }

      $long_name = $oim['name'];

      $short_name = str_replace('dzsvg_meta_', '', $oim['name']);


      if (isset($oim['default']) && $oim['default']) {

        $itemOptions[$oim['name']] = $oim['default'];
        $itemOptions[$short_name] = $oim['default'];


        $aux = get_post_meta($itemOptions['ID'], $long_name);
        if (get_post_meta($itemOptions['ID'], $long_name)) {

          if (isset($aux[0])) {
            $itemOptions[$long_name] = $aux[0];
            $itemOptions[$short_name] = $aux[0];
          }
        }
      } else {


        $itemOptions[$oim['name']] = get_post_meta($po_id, $oim['name'], true);
        $itemOptions[$short_name] = get_post_meta($po_id, $long_name, true);
      }


    }


    if (get_post_meta($po_id, 'dzsvg_meta_replace_artistname', true)) {
      $itemOptions['artistname'] = get_post_meta($po_id, 'dzsvg_meta_replace_artistname', true);
    }

    if (get_post_meta($po_id, 'dzsvg_meta_replace_menu_artistname', true)) {
      $itemOptions['menu_artistname'] = get_post_meta($po_id, 'dzsvg_meta_replace_menu_artistname', true);
    }

    if (get_post_meta($po_id, 'dzsvg_meta_replace_menu_songname', true)) {
      $itemOptions['menu_songname'] = get_post_meta($po_id, 'dzsvg_meta_replace_menu_songname', true);
    }


    $itemOptions['sourceogg'] = '';


    if (get_post_meta($po_id, 'dzsvg_meta_item_thumb', true)) {
      $itemOptions['thumb'] = get_post_meta($po_id, 'dzsvg_meta_item_thumb', true);
    } else {

      $itemOptions['thumb'] = get_post_meta($po_id, 'dzsvg_meta_thumb', true);
    }

    $itemOptions['type'] = get_post_meta($po_id, 'dzsvg_meta_type', true);
    $itemOptions['playerid'] = $po_id;


    $arr_metas_we_are_after = array('adarray');
    $meta_all = get_post_meta($po_id);

    foreach ($arr_metas_we_are_after as $lab => $vallab) {
      if (isset($meta_all[$vallab]) && $meta_all[$vallab] && $meta_all[$vallab][0]) {
        $itemOptions[$vallab] = $meta_all[$vallab][0];
      }
    }


    $itemOptions['title'] = '';
    $itemOptions['description'] = '';

    if (isset($itemOptions['post_title'])) {

      $itemOptions['title'] = $itemOptions['post_title'];
    }

    if (isset($itemOptions['post_content'])) {

      $itemOptions['description'] = $itemOptions['post_content'];
    }
    if (get_post_meta($po_id, 'dzsvg_meta_featured_media', true)) {

      $itemOptions['source'] = get_post_meta($po_id, 'dzsvg_meta_featured_media', true);
    }
    $itemOptions['type'] = get_post_meta($po_id, 'dzsvg_meta_item_type', true);
    $itemOptions['loop'] = get_post_meta($po_id, 'dzsvg_meta_loop', true);
    $itemOptions['is_360'] = get_post_meta($po_id, 'dzsvg_meta_is_360', true);
    if (get_post_meta($po_id, 'dzsvg_meta_ad_array', true)) {
      $itemOptions['adarray'] = get_post_meta($po_id, 'dzsvg_meta_ad_array', true);
    }
    if (get_post_meta($po_id, 'dzsvg_meta_subtitle', true)) {
      $itemOptions['subtitle'] = get_post_meta($po_id, 'dzsvg_meta_subtitle', true);
    }
    $itemOptions['audioimage'] = get_post_meta($po_id, 'dzsvg_meta_audioimage', true);
    $itemOptions['menuDescription'] = $itemOptions['menu_description'];
    $itemOptions['thumbnail'] = ClassDzsvgHelpers::get_post_thumb_src($po_id);

    // -- final sanitize
    if (isset($itemOptions['play_from']) && $itemOptions['play_from']) {
      $itemOptions['playfrom'] = $itemOptions['play_from'];
    }


    return $itemOptions;
  }


  static function style_player($selector, $vpsettings, $pargs = array()) {

    global $dzsvg;

    $fout = '';


    $margs = array(

      'gallery' => ''
    );


    $margs = array_merge($margs, $pargs);


    if ($selector) {

    } else {
      $selector = '.vp' . '0';
    }


    // -- we move this into footer for theme excerpt purpose
    $dzsvg->str_footer_css .= $selector . ' { background-color:' . $dzsvg->mainoptions_dc['background'] . ';} ';
    $dzsvg->str_footer_css .= $selector . ' .cover-image > .the-div-image { background-color:' . $dzsvg->mainoptions_dc['background'] . ';} ';
    $dzsvg->str_footer_css .= $selector . ' .background { background-color:' . $dzsvg->mainoptions_dc['controls_background'] . '!important;} ';
    $dzsvg->str_footer_css .= $selector . ' .scrub-bg{ background-color:' . $dzsvg->mainoptions_dc['scrub_background'] . '!important;} ';
    $dzsvg->str_footer_css .= $selector . ' .scrub-buffer{ background-color:' . $dzsvg->mainoptions_dc['scrub_buffer'] . '!important;} ';

    $dzsvg->str_footer_css .= $selector . ' .playcontrols .playSimple path,' . $selector . ' .playcontrols .pauseSimple  path{ fill:' . $dzsvg->mainoptions_dc['controls_color'] . '!important;}  ' . $selector . ' .dzsvg-control,  ' . $selector . ' .dzsvg-control a >i{ color: ' . $dzsvg->mainoptions_dc['controls_color'] . '!important; }  ' . $selector . ' .volumeicon path{ fill: ' . $dzsvg->mainoptions_dc['controls_color'] . '!important; }  ' . $selector . ' .fscreencontrols rect, ' . $selector . ' .fscreencontrols polygon { fill: ' . $dzsvg->mainoptions_dc['controls_color'] . '!important; } ' . $selector . ' .hdbutton-con .hdbutton-normal{ color: ' . $dzsvg->mainoptions_dc['controls_color'] . '!important; }   ';

    $dzsvg->str_footer_css .= $selector . ' .playSimple{ border-left-color:' . $dzsvg->mainoptions_dc['controls_color'] . '!important;  } .vplayer.skin_reborn .pauseSimple:before, .vplayer.skin_reborn .pauseSimple:after{ background-color:' . $dzsvg->mainoptions_dc['controls_color'] . '!important;  } ' . $selector . ' .skin_reborn .playcontrols{ background-color:' . $dzsvg->mainoptions_dc['controls_background'] . '!important; } ' . $selector . ' .skin_reborn .volume_static .volbar{ background-color:' . $dzsvg->mainoptions_dc['controls_background'] . '!important; } ' . $selector . ' .skin_reborn .volume_static .volbar.active{ background-color:' . $dzsvg->mainoptions_dc['controls_highlight_color'] . '!important; } ';

    $dzsvg->str_footer_css .= $selector . ' .playcontrols  .playSimple:hover path{ fill: ' . $dzsvg->mainoptions_dc['controls_hover_color'] . '!important; } ' . $selector . ' .playcontrols  .pauseSimple:hover path{ fill: ' . $dzsvg->mainoptions_dc['controls_hover_color'] . '!important; }  ' . $selector . ' .volumeicon:hover path{ fill: ' . $dzsvg->mainoptions_dc['controls_hover_color'] . '!important; }  .hdbutton-con:hover .hdbutton-normal{ color: ' . $dzsvg->mainoptions_dc['controls_hover_color'] . '!important; }      ' . $selector . ' .fscreencontrols:hover rect, ' . $selector . ' .fscreencontrols:hover polygon { fill: ' . $dzsvg->mainoptions_dc['controls_hover_color'] . '!important; }    ' . $selector . ' .dzsvg-control:hover, ' . $selector . ' .dzsvg-control:hover a > i{ color: ' . $dzsvg->mainoptions_dc['controls_hover_color'] . '!important; }     ';


    $dzsvg->str_footer_css .= $selector . ':not(.skin_white) .volume_active{ background-color: ' . $dzsvg->mainoptions_dc['controls_highlight_color'] . '!important; } ' . $selector . ' .scrub{ background-color: ' . $dzsvg->mainoptions_dc['controls_highlight_color'] . '!important; } ' . $selector . ' .hdbutton-con .hdbutton-hover{ color: ' . $dzsvg->mainoptions_dc['controls_highlight_color'] . '!important; } ';

    $dzsvg->str_footer_css .= ' .vplayer.skin_reborn .volume_active{ background-color: transparent!important; }';
    $dzsvg->str_footer_css .= $selector . ' .curr-timetext{ color: ' . $dzsvg->mainoptions_dc['timetext_curr_color'] . '; } ';


    return $fout;
  }

  public static function sanitizeShortcodeAttrToWithoutLink($input_line) {

    $fout = $input_line;

    if (preg_match('/href=\"(.*?)\"/', $input_line, $output_array)) {
      if (isset($output_array[1]) && $output_array[1]) {
        $fout = $output_array[1];
      }
    }

    return $fout;

  }

  public static function sanitizeArgsForParseItem(&$che) {

    $aux = 'overwrite_responsive_ratio';
    if (isset($che[$aux]) && $che[$aux] != '') {
      $che['responsive_ratio'] = $che[$aux];
    }
    $aux = 'the_post_content';
    if (isset($che[$aux]) && $che[$aux]) {
      if (!(isset($che['description']) && $che['description'])) {
        $che['description'] = $che[$aux];
      }
    }

    $fieldTemp = 'thethumb';
    $fieldReal = 'thumbnail';
    if (isset($che[$fieldTemp]) && $che[$fieldTemp]) {
      if (!(isset($che[$fieldReal]) && $che[$fieldReal])) {
        $che[$fieldReal] = $che[$fieldTemp];
      }
    }

  }

  public static function galleryHasExtraControls($its) {
    return (isset($its['settings']['enable_info_button']) && $its['settings']['enable_info_button'] == 'on') || (isset($its['settings']['enable_link_button']) && $its['settings']['enable_link_button'] == 'on') || (isset($its['settings']['enable_cart_button']) && $its['settings']['enable_cart_button'] == 'on') || (isset($its['settings']['enable_quality_changer_button']) && $its['settings']['enable_quality_changer_button'] == 'on') || (isset($its['settings']['enable_multisharer_button']) && $its['settings']['enable_multisharer_button'] == 'on');
  }


  static function sanitize_forUrl($arg) {
    $arg = str_replace('"', '', $arg);
    $arg = str_replace('&#8221;', '', $arg);
    $arg = str_replace('&#8243;', '', $arg);
    return $arg;
  }

  static function sanitize_forJsSnippet($arg) {

    $lb = array("\r\n", "\n", "\r");
    $arg = str_replace($lb, '', $arg);


    // -- we will prepare for ' wrap
    $arg = str_replace(array("'"), '&quot;', $arg);
    $arg = str_replace(array("{squote}"), '\\\'', $arg);

    // -- wordfence workaround..
    $arg = str_replace(array("{onclick}"), 'onclick', $arg);

    return $arg;
  }


  static function sanitize_encodeForSlidersChange($subvalue) {
    // -- used in LEGACY mode

    $subvalue = (string)$subvalue;
    $subvalue = stripslashes($subvalue);
    $subvalue = str_replace(array("\r", "\r\n", "\n", '\\', "\\"), '', $subvalue);
    $subvalue = str_replace(array("'"), '"', $subvalue);
    $subvalue = str_replace(array("</script>"), '{{endscript}}', $subvalue);


    return $subvalue;
  }

  static function sanitize_fromShortcodeAttr($arg, $che = array()) {

    $arg = str_replace('{{lsqb}}', '[', $arg);
    $arg = str_replace('{{rsqb}}', ']', $arg);
    $arg = str_replace('&#8221;', '', $arg);
    $arg = str_replace('&#8217;', '', $arg);


    $arg = str_replace('{{linkedid}}', '', $arg);
    $lab = 'itunes_link';
    if (isset($che[$lab])) {
      $arg = str_replace('{{' . $lab . '}}', $che[$lab], $arg);
    } else {

      $arg = str_replace('{{' . $lab . '}}', '', $arg);
    }


    return $arg;
  }


  static function sanitize_youtubeUrlToId($arg) {

    if (strpos($arg, 'youtube.com/embed') !== false) {
      $auxa = explode('/', 'youtube.com/embed/');

      if ($auxa[1]) {

        return $auxa[1];
      }
    }


    if (strpos($arg, 'youtube.com') !== false || strpos($arg, 'youtu.be') !== false) {


      if (DZSHelpers::get_query_arg($arg, 'v')) {
        return DZSHelpers::get_query_arg($arg, 'v');
      }

      if (strpos($arg, 'youtu.be') !== false) {
        $auxa = explode('/', 'youtube.com/embed/');

        $arg = $auxa[count($auxa) - 1];
      }
    }


    return $arg;
  }


  static function sanitize_termSlugToId($arg, $taxonomy_name = DZSVG_POST_NAME__CATEGORY) {


    if (is_numeric($arg)) {

    } else {


      if (is_int($arg) || is_string($arg)) {

        $term = get_term_by('slug', $arg, $taxonomy_name);

        if ($term) {
          $arg = $term->term_id;
        }
      } else {
        return $arg;
      }

    }


    return $arg;
  }


  public static function sanitize_for_javascript_double_quote_value($arg) {

    $arg = str_replace('"', '', $arg);

    if ($arg == '/') {
      $arg = '';
    }

    return $arg;

  }

  public static function player_fromMargsShortcodeToIts($margs, &$its) {

    global $dzsvg;
    if ($margs['sourceogg'] != '') {
      $its[0]['html5sourceogg'] = $margs['sourceogg'];
    }
    if ($margs['cover'] != '') {
      $its['settings']['coverImage'] = $margs['cover'];
    }
    if ($margs['title']) {
      $its[0]['title'] = $margs['title'];
    }
    if ($margs['loop']) {
      $its[0]['loop'] = $margs['loop'];
    }
    if ($margs['logo']) {
      $its[0]['logo'] = $margs['logo'];
    }
    if ($margs['logo_link']) {
      $its[0]['logo_link'] = $margs['logo_link'];
    }
    if ($margs['description']) {
      $its[0]['description'] = $margs['description'];
    }
    if ($margs['link']) {
      $its[0]['link'] = $margs['link'];
    }
    if ($margs['link_label']) {
      $its[0]['link_label'] = $margs['link_label'];
    }
    if (isset($margs['adarray']) && $margs['adarray']) {
      $its[0]['adarray'] = ClassDzsvgHelpers::sanitize_decodeForHtmlAttributes($margs['adarray']);
    }
    if ($margs['is_360']) {
      $its[0]['is_360'] = $margs['is_360'];
    }
  }


  static function sanitize_from_anchor_to_shortcode_attr($arg) {
    $input_lines = $arg;

    $input_lines = str_replace('&#8221;', '', $input_lines);
    $input_lines = str_replace('<wbr />', '', $input_lines);
    preg_match_all("/href=\"(.*?)\"/", $input_lines, $output_array);

    if (isset($output_array[1]) && isset($output_array[1][0])) {


      return $output_array[1][0];
    }

    return $input_lines;
  }

  static function sanitize_forKey($string) {
    $string = str_replace(' ', '-', $string); // Replaces all spaces with hyphens.
    $string = str_replace('?', '-', $string); // Replaces all spaces with hyphens.

    return preg_replace('/[^A-Za-z0-9\-]/', '', $string); // Removes special chars.
  }

  static function sanitize_decodeForHtmlAttributes($arg) {

    $fout = html_entity_decode($arg);

    $fout = str_replace('{{quot}}', '"', $fout);
    $fout = str_replace('{patratstart}', '[', $fout);
    $fout = str_replace('{patratend}', ']', $fout);


    return $fout;
  }

  public static function getVideoPlayerConfig($margs) {

    global $dzsvg;


    $vpconfig_k = 0;
    $vpconfig_id = '';

    $vpsettingsdefault = array_merge($dzsvg->vpsettingsdefault, array());
    $vpsettings = array(
      'settings' => array()
    );


    if ($margs['config'] != '') {
      $vpconfig_id = $margs['config'];
    }

    if ($vpconfig_id != '') {
      for ($i = 0; $i < count($dzsvg->mainvpconfigs); $i++) {
        if ((isset($vpconfig_id)) && ($vpconfig_id == $dzsvg->mainvpconfigs[$i]['settings']['id'])) $vpconfig_k = $i;
      }
      $vpsettings = $dzsvg->mainvpconfigs[$vpconfig_k];
      if (!isset($vpsettings['settings']) || $vpsettings['settings'] == '') {
        $vpsettings['settings'] = array();
      }
    }

    if (!isset($vpsettings['settings']) || (isset($vpsettings['settings']) && !is_array($vpsettings['settings']))) {
      $vpsettings['settings'] = array();
    }
    $vpsettings['settings'] = array_merge($vpsettingsdefault, $vpsettings['settings']);
    $vpsettings['settings']['vpconfig_id'] = $vpconfig_id;
    return $vpsettings;

  }

  public static function legacyGenerateHtmlExportDatabaseForVideoConfig() {

    ?>Please note that this feature uses the last saved data. Unsaved changes will not be exported.
    <form action="<?php echo site_url() . '/wp-admin/options-general.php?page=dzsvg_menu'; ?>" method="POST">
      <input type="hidden" class="hidden" name="slidernr" value="<?php echo $_GET['slidernr']; ?>"/>
      <input type="hidden" class="hidden" name="slidername" value="<?php echo $_GET['slidername']; ?>"/>
      <input type="hidden" class="hidden" name="currdb" value="<?php echo $_GET['currdb']; ?>"/>
      <input class="button-secondary" type="submit" name="dzsvg_exportslider_config" value="Export"/>
    </form>
    <?php
  }

  public static function legacyGenerateHtmlExportDatabaseForSlider() {

    ?>Please note that this feature uses the last saved data. Unsaved changes will not be exported.
    <form action="<?php echo site_url() . '/wp-admin/options-general.php?page=dzsvg_menu'; ?>" method="POST">
      <input type="hidden" class="hidden" name="slidernr" value="<?php echo $_GET['slidernr']; ?>"/>
      <input type="hidden" class="hidden" name="slidername" value="<?php echo $_GET['slidername']; ?>"/>
      <input type="hidden" class="hidden" name="currdb" value="<?php echo $_GET['currdb']; ?>"/>
      <input class="button-secondary" type="submit" name="dzsvg_exportslider" value="Export"/>
    </form>
    <?php
  }

  public static function legacyExportDatabaseController() {

    if (isset($_GET['dzsvg_show_generator_export_slider']) && $_GET['dzsvg_show_generator_export_slider'] == 'on') {
      ClassDzsvgHelpers::legacyGenerateHtmlExportDatabaseForSlider();
      die();
    }


    if (isset($_GET['dzsvg_show_generator_export_slider_config']) && $_GET['dzsvg_show_generator_export_slider_config'] == 'on') {
      ClassDzsvgHelpers::legacyGenerateHtmlExportDatabaseForVideoConfig();
      die();
    }


  }

  public static function get_post_thumb_src($it_id) {

    if (get_post_meta($it_id, 'dzsvg_meta_thumb', true)) {
      $imgsrc = get_post_meta($it_id, 'dzsvg_meta_thumb', true);

      return $imgsrc;
    } else {

      $imgsrc = wp_get_attachment_image_src(get_post_thumbnail_id($it_id), "full");

      if (isset($imgsrc[0])) {

        return $imgsrc[0];
      }
    }

    return null;

  }


}