<?php
return array(


  'track_views' => array(
    'type' => 'checkbox',
    'category' => 'main',
    'default' => 'off',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Track views', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('Track views on video posts', DZSVG_ID),
  ),
  'admin_try_to_generate_thumb_for_self_hosted_videos' => array(
    'type' => 'checkbox',
    'category' => 'main',
    'default' => 'on',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Try to generate thumbnails for self hosted videos.', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('Try to generate thumbnails for self hosted videos.', DZSVG_ID),
  ),
  'videoplayer_end_exit_fullscreen' => array(
    'type' => 'checkbox',
    'category' => 'main',
    'default' => 'on',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Exit Fullscreen on Video End', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('exit fullscreen mode when video has ended or remain fullscreen ?', DZSVG_ID),
  ),
  'enable_cs' => array(
    'type' => 'checkbox',
    'category' => 'main',
    'default' => 'off',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Enable CornerStone Support', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('enable CornerStone support', DZSVG_ID),
  ),
  'replace_wpvideo' => array(
    'type' => 'checkbox',
    'category' => 'main',
    'default' => 'off',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Replace [video] Shortcode for Simple Videos', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('render simple wp videos with DZS Video Gallery', DZSVG_ID),
  ),
  'disable_fontawesome' => array(
    'type' => 'checkbox',
    'category' => 'main',
    'default' => 'off',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Disable FontAwesome', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('do not include the fontawesome library', DZSVG_ID),
  ),
  'always_embed' => array(
    'type' => 'checkbox',
    'category' => 'main',
    'default' => 'off',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Always Embed Scripts?', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('by default scripts and styles from this gallery are included only when needed for optimizations reasons, but you can choose to always use them ( useful for when you are using a ajax theme that does not reload the whole page on url change )', DZSVG_ID),
  ),
  'settings_trigger_resize' => array(
    'type' => 'checkbox',
    'category' => 'main',
    'default' => 'off',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Force Refresh Size Every 1000ms', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('sometimes sizes need to be recalculated ( for example if you use the gallery in tabs )', DZSVG_ID),
  ),
  'loop_playlist' => array(
    'type' => 'checkbox',
    'category' => 'main',
    'default' => 'on',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Loop Playlist', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('loop the playlist after the last video has finished', DZSVG_ID),
  ),
  'enable_widget' => array(
    'type' => 'checkbox',
    'category' => 'main',
    'default' => 'on',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Enable Widget', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('enable widget for including in sidebar', DZSVG_ID),
  ),
  'enable_auto_backup' => array(
    'type' => 'checkbox',
    'category' => 'main',
    'default' => 'on',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Enable Autobackup', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('enable once per day autobackup of the main database', DZSVG_ID),
  ),
  'replace_default_video_playlist' => array(
    'type' => 'checkbox',
    'category' => 'main',
    'default' => 'off',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Replace default video playlist', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => wp_kses(sprintf(__('replace the default video playlist functionality. To configure options just create a gallery named %s', 'dzsvg'), '<strong>default_video_playlist</strong>'), DZSVG_HTML_ALLOWED_TAGS),
  ),


  'use_layout_builder_on_navigation' => array(
    'type' => 'checkbox',
    'category' => 'main',
    'default' => 'off',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Navigation - use layout builder', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => __('( beta )'),
  ),

  'enable_ie11_compatibility' => array(
    'type' => 'checkbox',
    'category' => 'main',
    'default' => 'off',
    'select_type' => ' ',
    'title' => esc_html__('Enable IE11 Compatibility', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__("if your users use ie11, you can use compatibilty mode, but the file size will increase", DZSVG_ID),
  ),


  'enable_developer_options' => array(
    'type' => 'checkbox',
    'category' => 'main',
    'default' => 'off',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Enable Developer Options', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('warning - only for developers', DZSVG_ID),
  ),

  // -- developer options

  'enable_legacy_gutenberg_block' => array(
    'type' => 'checkbox',
    'category' => 'developer_options',
    'default' => 'off',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Enable legacy', DZSVG_ID) . ' <strong>Gutenberg</strong> ' . esc_html__('blocks', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => __("enable the legacy gutenberg block"),
    'choices' => array(
      array(
        'label' => esc_html__("Disable", DZSVG_ID),
        'value' => 'off',
      ),
      array(
        'label' => esc_html__("Enable", DZSVG_ID),
        'value' => 'on',
      ),
    ),
  ),
  'is_safebinding' => array(
    'type' => 'checkbox',
    'category' => 'developer_options',
    'default' => 'on',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Safe binding?', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => __('the galleries admin can use a complex ajax backend to ensure fast editing, but this can cause limitation issues on php servers. Turn this to on if you want a faster editing experience ( and if you have less then 20 videos accross galleries ) '),
  ),
  'disable_api_caching' => array(
    'type' => 'checkbox',
    'category' => 'developer_options',
    'default' => 'off',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Do Not Use Caching', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => '<strong style="color: red">'.esc_html__('WARNING:', DZSVG_ID).'</strong>'.esc_html__('do not edit this unless you know what you are doing', DZSVG_ID). ' - '.esc_html__('use caching for vimeo / youtube api ( recommended - default )', DZSVG_ID),
  ),
  'admin_enable_for_users' => array(
    'type' => 'checkbox',
    'category' => 'developer_options',
    'default' => 'off',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Enable Visitors Gallery Access', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('your logged in users will be able to have their own galleries', DZSVG_ID),
  ),
  'replace_jwplayer' => array(
    'category' => 'developer_options',
    'type' => 'checkbox',
    'default' => 'off',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Replace JWPlayer', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('render jw player shortcodes with DZS Video Gallery', DZSVG_ID),
  ),
  'include_featured_gallery_meta' => array(
    'category' => 'developer_options',
    'type' => 'checkbox',
    'default' => 'off',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Include Featured Gallery Option', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => '[beta] ' . esc_html__('only works on certain themes', DZSVG_ID),
  ),
  'tinymce_enable_preview_shortcodes' => array(
    'category' => 'developer_options',
    'type' => 'checkbox',
    'default' => 'off',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Enable Preview Shortcodes in TinyMce Editor', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('add a box with the shortcode in the tinymce Visual Editor', DZSVG_ID),
  ),
  'use_external_uploaddir' => array(
    'category' => 'developer_options',
    'type' => 'checkbox',
    'default' => 'off',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('External Upload Dir', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('use external uploaddir', DZSVG_ID),
  ),
  'sliders_admin_solve_meta_query_conflicts' => array(
    'category' => 'developer_options',
    'type' => 'checkbox',
    'default' => 'off',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Sliders admin - Solve meta query conflicts', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('some plugins might try to hijack the meta query for ordering - you can make sure to get sorting right with this', DZSVG_ID),
  ),
  'debug_mode' => array(
    'category' => 'developer_options',
    'type' => 'checkbox',
    'default' => 'off',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Debug Mode', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('activate debug mode ( advanced mode )', DZSVG_ID),
  ),
  'extra_css_in_stylesheet' => array(
    'category' => 'developer_options',
    'type' => 'checkbox',
    'default' => 'off',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Put css in external stylesheet', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('put extra css in external stylesheet not in html inline', DZSVG_ID),
  ),
  'cache_time' => array(
    'category' => 'developer_options',
    'type' => 'text',
    'default' => '7202',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Cache Time in settings', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('*in seconds --- a value between 7200 ( 2 hours ) and 166400 is recommended', DZSVG_ID),
  ),
  'navigation_view_easing_duration' => array(
    'category' => 'appearance',
    'type' => 'text',
    'default' => '',
    'title' => esc_html__('Easing duration for hover animation', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('set a custom duration for the menu to scroll in ms - for example: ', DZSVG_ID) . ' <strong>30</strong> ' . esc_html__("or", DZSVG_ID) . ' <strong>40</strong> ' . esc_html__("for slower scrolling", DZSVG_ID) ,
  ),
  'facebook_player' => array(
    'category' => 'facebook',
    'type' => 'select',
    'default' => 'custom',
    'select_type' => 'opener-listbuttons ',
    'choices'=>array(
      array(
        'lab' => __('Custom player'),
        'val' => 'custom',
      ),
      array(
        'lab' => __('iFrame'),
        'val' => 'iframe',
      ),

    ),
    'title' => esc_html__('Facebook play in', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('a value between 7200 and 166400 is recommended', DZSVG_ID),
  ),
  'facebook_app_id' => array(
    'category' => 'facebook',
    'type' => 'text',
    'default' => '',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Facebook application ID', DZSVG_ID),
    'extra_classes' => '',
    'tooltip' => array(
      'image_url'=>ClassDzsvgHelpers::admin_documentationGetAsset('https://dl.dropboxusercontent.com/s/r6wwitu9e81vji7/dzsvg-facebook-app-id.jpg'),
      'description'=>'',
    ),
    'sidenote' => esc_html__("Tutorial", 'dzsvg') . ' <a href="https://zoomthe.me/themeadmin-dzsvg/knowledge-base/knowledge-base/facebook-create-application-for-getting-application-id-and-application-secret/" target="_blank">' . esc_html__("here", 'dzsvg') . '</a>' ,
  ),
  'facebook_app_secret' => array(
    'category' => 'facebook',
    'type' => 'text',
    'default' => '',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Facebook application secret', DZSVG_ID),
    'extra_classes' => '',
    'tooltip' => array(
      'image_url'=>ClassDzsvgHelpers::admin_documentationGetAsset('https://dl.dropbox.com/s/s3jblg15pomslpc/dzsvg-facebook-app-secret.jpg'),
      'description'=>'',
    ),
  ),
  'facebook_default_access_token' => array(
    'category' => 'facebook',
    'type' => 'text',
    'default' => '',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('(Optional) default access token', DZSVG_ID),
    'extra_classes' => '',
    'tooltip' => array(
      'image_url'=>ClassDzsvgHelpers::admin_documentationGetAsset('https://dl.dropbox.com/s/zjg6fyiujsbdmc5/dzsvg-facebook-default-access-token.jpg'),
      'description'=>'',
    ),
    'sidenote' => esc_html__("Go", 'dzsvg') . ' <a href="https://developers.facebook.com/tools/explorer/" target="_blank">' . esc_html__("here", 'dzsvg') . '</a> ' . esc_html__(' and click Generate New Token; copy that token and paste it here') ,
  ),

  'deeplink_str' => array(
    'category' => 'main',
    'type' => 'text',
    'default' => 'the-video',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Deeplink structure permalink', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('the format of the permalink', DZSVG_ID),
  ),


  'dzsvp_tabs_breakpoint' => array(
    'category' => 'developer_options',
    'type' => 'text',
    'default' => '',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Upload Form Breakpoint', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('the breakpoint of the front end video submit  form - in which the tabs transform to accordions', DZSVG_ID),
  ),
  'advanced_videopage_custom_action_contor_10_secs' => array(
    'category' => 'developer_options',
    'type' => 'textarea',
    'default' => '',
    'select_type' => 'opener-listbuttons ',
    'title' => esc_html__('Video Page 10 sec. Javascript Function', DZSVG_ID),
    'extra_classes' => '',
    'sidenote' => esc_html__('warning - developers only', DZSVG_ID),
  ),

);