// ==ClosureCompiler==
// @output_file_name default.js
// @compilation_level SIMPLE_OPTIMIZATIONS
// ==/ClosureCompiler==

/*
 * Author: Digital Zoom Studio
 * Website: http://digitalzoomstudio.net/
 * Portfolio: http://codecanyon.net/user/ZoomIt/portfolio?ref=ZoomIt
 * This is not free software.
 * Advanced Scroller v1.45
 */

"use strict";
window.dzsas_self_options = {};


(function ($) {
    var target_swiper;
    $.fn.advancedscroller = function (o) {
        var defaults = {
            settings_slideshowTime: '5' //in seconds
            , settings_autoHeight: 'on'
            , settings_autoHeight_proportional: 'off' // -- set proportional height of the image depending on the width
            , settings_autoHeight_proportional_max_height: 500 // -- the height on which shall not be passed

            , design_itemheight: '200'
            , design_arrowsize: 'default' // -- set the left and right arrow size, this is the size of an arrow
            , design_bulletspos: 'default' // --- set the bullets position top, bottom or default ( set by the skin ) or none
            , design_disableArrows: 'default'
            , design_forceitemwidth: ''
            , settings_transition: 'slide' // "slide" or "fade" or "wipeoutandfade" or "testimonials_transition_1"
            , settings_direction: 'horizontal'
            , settings_responsive: 'on'
            , settings_mode: 'normal'// -- normal or onlyoneitem
            , settings_swipe: "on"
            , settings_swipeOnDesktopsToo: "off" // -- if this is on then on desktops the transition will be set to SLIDE
            , settings_makeFunctional: true
            , settings_centeritems: false
            , settings_slideshow: 'off'
            , settings_lazyLoading: 'off'
            , settings_force_immediate_load: 'off' // -- force immediate load even if there are items to be loaded
            , settings_slideshowDontChangeOnHover: 'on'
            , settings_transition_only_when_loaded: 'off' // -- transition only when the image has fully loaded
            , settings_wait_for_do_transition_call: 'off' // -- [advanced] set this when the transition is actually called from an outer function / api
            , settings_secondCon: null
            , mode_onlyone_autoplay_videos: 'on' // -- autoplay videos when scrolled to the video
            , mode_onlyone_reset_videos_to_0: 'off' // -- on item select , if the item is a video, reset the scrub to 0
            , design_itemwidth: '200'
            , responsive_720_design_itemwidth: ''
            , responsive_480_design_itemwidth: ''
        };


        if (typeof o == 'undefined') {
            if (typeof $(this).attr('data-options') != 'undefined') {
                var aux = $(this).attr('data-options');

                var aux_opts = null;
                aux = 'window.dzsas_self_options = ' + aux;
                eval(aux);

                o = $.extend({}, window.dzsas_self_options);
                window.dzsas_self_options = $.extend({}, {});


            }
        }
        o = $.extend(defaults, o);

        this.each(function () {
            var cthis = $(this)
            ;
            var nrItems = 0;
            var currNr = -1;
            var busy = true;
            var i = 0
              , startIndex = 0
            ;
            var ww
              , wh
              , tw // total width of the container and h
              , th
              , cw // clip w and h
              , ch
              , realcw // clip w and h
              , realch
            ;
            var
              items_per_page = 0
            ;
            var
              _items
              , _thumbsCon
              , _thumbsClip
              , _bulletsCon
              , _arrowsCon
            ;
            var
              pag_total_thumbsizes = 0
              , pag_total_thumbnr = 0 // = total number of thumbnails
              , pag_total_pagenr = 0 // = total number of pages
              , pag_excess_thumbnr = 0 // = the excess thumbs which go

            ;
            var currPage = -1
              , currPageX = 0
              , tempPage = 0
              , lastArg = 0 // -- the last current transitioning item
            ;
            //===slideshow vars
            var slideshowInter
              , slideshowCount = 0
              , slideshowTime
              , inter_wait_loaded = null
            ;


            var sw_ctw = 0
              , sw_tw = 0
            ;

            var loadedArray = []
              , lazyLoadingArray = []
              , itemsToBeArray = []
            ;

            var design_itemwidth = 0;


            var action_call_on_gotoItem = null;

            var inter_calculate_hard = 0;
            var is_over = false;
            var busy = false
              , paused_roll = false
            ;
            var aux;
            var misc_has_height_same_as_width_elements = false;

            if (String(o.design_itemwidth) != 'auto' && String(o.design_itemwidth).indexOf("%") == -1) {
                o.design_itemheight = parseInt(o.design_itemheight, 10);
            } else {
            }
            design_itemwidth = o.design_itemwidth;

            if (design_itemwidth == '25%') {
                if (o.responsive_720_design_itemwidth == '') {
                    o.responsive_720_design_itemwidth = '50%'
                }
                if (o.responsive_480_design_itemwidth == '') {
                    o.responsive_480_design_itemwidth = '100%'
                }
            }


            if (isNaN(Number(o.design_arrowsize)) == false) {
                o.design_arrowsize = Number(o.design_arrowsize);
            }

            o.settings_slideshowTime = parseInt(o.settings_slideshowTime, 10);
            o.design_forceitemwidth = parseInt(o.design_forceitemwidth, 10);
            slideshowTime = o.settings_slideshowTime;
            init();


            if (document.addEventListener) {
                document.addEventListener("fullscreenchange", handle_fs, false);
                document.addEventListener("webkitfullscreenchange", handle_fs, false);
                document.addEventListener("mozfullscreenchange", handle_fs, false);
            }


            function handle_fs(e) {
                var fs = window.fullScreenApi.isFullScreen();
                if (fs) {
                } else {
                    setTimeout(function () {
                        handleResize();
                    }, 100);
                }
            }

            function init() {
                if (cthis.hasClass('inited')) {
                    return;
                }


                th = cthis.outerHeight(false);

                if (cthis.attr('class').indexOf("skin-") === -1) {
                    cthis.addClass(o.settings_skin);
                }
                if (cthis.hasClass('skin-default')) {
                    o.settings_skin = 'skin-default';
                }
                if (cthis.hasClass('skin-inset')) {
                    o.settings_skin = 'skin-inset';
                }
                if (cthis.hasClass('skin-agata-inset')) {
                    o.settings_skin = 'skin-inset';
                    o.design_arrowsize = 0;
                }
                if (cthis.hasClass('skin-black')) {
                    o.settings_skin = 'skin-black';
                }
                if (cthis.hasClass('skin-regen')) {
                    o.settings_skin = 'skin-regen';
                    if (o.design_arrowsize == 'default') {
                        o.design_arrowsize = 0;
                    }
                    if (o.design_bulletspos == 'default') {
                        o.design_bulletspos = 'none';
                    }
                }
                if (cthis.hasClass('skin-karma-inset')) {
                    o.settings_skin = 'skin-karma-inset';
                    if (o.design_arrowsize == 'default') {
                        o.design_arrowsize = 0;
                    }
                    if (o.design_bulletspos == 'default') {
                        o.design_bulletspos = 'none';
                    }
                }
                if (cthis.hasClass('skin-avanti-inset')) {
                    o.settings_skin = 'skin-avanti-inset';
                    if (o.design_arrowsize == 'default') {
                        o.design_arrowsize = 0;
                    }
                    if (o.design_bulletspos == 'default') {
                        o.design_bulletspos = 'none';
                    }
                }
                if (cthis.hasClass('skin-whitefish')) {
                    o.settings_skin = 'skin-whitefish';
                    if (o.design_arrowsize == 'default') {
                        o.design_arrowsize = 0;
                    }
                }
                if (cthis.hasClass('skin-bubble-inset')) {
                    o.settings_skin = 'skin-bubble-inset';
                    if (o.design_arrowsize == 'default') {
                        o.design_arrowsize = 0;
                    }
                    if (o.design_bulletspos == 'default') {
                        o.design_bulletspos = 'none';
                    }
                }
                if (cthis.hasClass('skin-nonav')) {
                    o.settings_skin = 'skin-nonav';
                    if (o.design_arrowsize == 'default') {
                        o.design_arrowsize = 0;
                    }
                    if (o.design_bulletspos == 'default') {
                        o.design_bulletspos = 'none';
                    }
                }

                if (cthis.hasClass('skin-giza')) {
                    o.settings_skin = 'skin-giza';
                    if (o.design_arrowsize == 'default') {
                        o.design_arrowsize = 0;
                    }
                    if (o.design_bulletspos == 'default') {
                        o.design_bulletspos = 'none';
                    }
                }

                if (cthis.hasClass('skin-qcre')) {
                    o.settings_skin = 'skin-qcre';
                    if (o.design_arrowsize == 'default') {
                        o.design_arrowsize = 0;
                    }
                    if (o.design_bulletspos == 'default') {
                        o.design_bulletspos = 'none';
                    }
                }

                if (cthis.hasClass('skin-trumpet')) {
                    o.settings_skin = 'skin-trumpet';
                    if (o.design_arrowsize == 'default') {
                        o.design_arrowsize = 0;
                    }
                    if (o.design_bulletspos == 'default') {
                        o.design_bulletspos = 'none';
                    }
                }


                if (cthis.hasClass('skin-giza-bullets')) {
                    o.settings_skin = 'skin-giza-bullets';
                    if (o.design_arrowsize == 'default') {
                        o.design_arrowsize = 0;
                    }
                    if (o.design_bulletspos == 'default') {
                        o.design_bulletspos = 'bottom';
                    }

                    if (o.design_disableArrows === 'default') {
                        o.design_disableArrows = 'on';
                    }
                }

                if (!(is_ie() && version_ie < 9) && (o.settings_swipeOnDesktopsToo == 'on' || (o.settings_swipeOnDesktopsToo == 'off' && (is_ios() || is_android()) && o.settings_swipe == 'on'))) {


                    o.settings_transition = 'slide';
                }


                cthis.addClass('mode-' + o.settings_mode);
                cthis.addClass('transition-' + o.settings_transition);

                if (o.design_arrowsize == 'default') {
                    o.design_arrowsize = 40;
                }
                if (o.design_bulletspos == 'default') {
                    o.design_bulletspos = 'bottom';
                }

                if (o.design_disableArrows == 'default') {
                    o.design_disableArrows = 'off';
                }


                if (o.design_bulletspos == 'top') {
                    cthis.append('<div class="bulletsCon"></div>');
                }
                cthis.append('<div class="thumbsCon" style="opacity: 0;"><ul class="thumbsClip"></ul></div>');
                if (o.design_bulletspos == 'bottom') {
                    cthis.append('<div class="bulletsCon"></div>');
                }
                if (o.design_disableArrows != 'on') {
                    cthis.append('<div class="arrowsCon"></div>');
                }

                _items = cthis.children('.items').eq(0);
                _bulletsCon = cthis.children('.bulletsCon').eq(0);
                _thumbsCon = cthis.children('.thumbsCon').eq(0);
                _thumbsClip = cthis.find('.thumbsClip').eq(0);
                _arrowsCon = cthis.find('.arrowsCon').eq(0);

                nrItems = _items.children().length;

                if (cthis.find('.js-height-same-as-width')) {
                    misc_has_height_same_as_width_elements = true;
                }


                var ind = 0;
                itemsToBeArray = _items.children('.item-tobe');

                _items.children('.item-tobe').each(function () {
                    var _t = $(this);
                    var ind2 = _t.parent().children().index(_t);


                    aux = design_itemwidth;
                    _t.addClass('item').removeClass('item-tobe');
                    if (aux != 'auto' && aux != '' && cthis.hasClass('mode-onlyoneitem') == false) {

                        _t.css({
                            'width': aux
                        });
                    }
                    _thumbsClip.append(_t);

                    if (o.settings_lazyLoading == 'on') {
                        if (_t.find('.imagediv').length == 0 && _t.find('img').length == 0) {
                            lazyLoadingArray[ind] = 'tobeloaded';
                        } else {
                            lazyLoadingArray[ind] = 'loaded';
                        }
                    }

                    loadedArray[ind] = 1;
                    ind++;


                });

                _arrowsCon.append('<div class="arrow-left"></div>');
                _arrowsCon.append('<div class="arrow-right"></div>');

                if (o.settings_skin === 'skin-avanti-inset') {
                    _arrowsCon.find('.arrow-left').eq(0).append('<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="17.153px" height="29.969px" viewBox="0 0 17.153 29.969" enable-background="new 0 0 17.153 29.969" xml:space="preserve"> <g> <g> <path fill="#CBCAC1" d="M14.566,0.316C9.947,4.933,5.329,9.55,0.709,14.167c-0.457,0.456,0.25,1.164,0.707,0.707 c4.619-4.617,9.238-9.233,13.857-13.85C15.729,0.567,15.022-0.14,14.566,0.316L14.566,0.316z"/> </g> </g> <g> <g> <path fill="#CBCAC1" d="M0.709,14.874c4.903,4.901,9.806,9.802,14.709,14.703c0.456,0.456,1.163-0.251,0.707-0.707 c-4.903-4.901-9.806-9.802-14.709-14.703C0.96,13.71,0.253,14.417,0.709,14.874L0.709,14.874z"/> </g> </g> </svg> ');
                    _arrowsCon.find('.arrow-right').eq(0).append('<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="17.153px" height="29.969px" viewBox="0 0 17.153 29.969" enable-background="new 0 0 17.153 29.969" xml:space="preserve"> <g> <g> <path fill="#CBCAC1" d="M1.538,1.061c4.661,4.617,9.323,9.233,13.983,13.85c0.459,0.454,1.166-0.252,0.707-0.707 c-4.66-4.617-9.322-9.233-13.983-13.85C1.787-0.1,1.08,0.607,1.538,1.061L1.538,1.061z"/> </g> </g> <g> <g> <path fill="#CBCAC1" d="M15.521,14.204c-4.947,4.9-9.896,9.801-14.844,14.703c-0.458,0.453,0.249,1.16,0.707,0.707 c4.948-4.9,9.896-9.803,14.844-14.704C16.688,14.458,15.98,13.75,15.521,14.204L15.521,14.204z"/> </g> </g> </svg>  ');
                }
                if (o.settings_skin === 'skin-bubble-inset') {
                    _arrowsCon.find('.arrow-left').eq(0).append('<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="43.625px" height="43.625px" viewBox="-13.236 -6.791 43.625 43.625" enable-background="new -13.236 -6.791 43.625 43.625" xml:space="preserve"> <g id="Layer_2"> <circle fill="#DB4343" cx="8.576" cy="15.021" r="21.812"/> </g> <g id="Layer_1"> <g> <g> <path fill="#CBCAC1" d="M11.428,5.492C8.42,8.5,5.412,11.507,2.403,14.514c-0.297,0.297,0.163,0.758,0.461,0.46 c3.009-3.007,6.017-6.014,9.025-9.021C12.186,5.656,11.725,5.195,11.428,5.492L11.428,5.492z"/> </g> </g> <g> <g> <path fill="#CBCAC1" d="M2.403,14.975c3.193,3.193,6.387,6.385,9.581,9.577c0.297,0.297,0.758-0.163,0.461-0.46 c-3.194-3.193-6.388-6.385-9.581-9.578C2.566,14.217,2.106,14.677,2.403,14.975L2.403,14.975z"/> </g> </g> </g> </svg> ');
                    _arrowsCon.find('.arrow-right').eq(0).append('<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="43.625px" height="43.625px" viewBox="-13.236 -6.791 43.625 43.625" enable-background="new -13.236 -6.791 43.625 43.625" xml:space="preserve"> <g id="Layer_2"> <circle fill="#DB4343" cx="8.576" cy="15.021" r="21.812"/> </g> <g id="Layer_1"> <g> <g> <path fill="#CBCAC1" d="M5.54,25.236c3.032-3.031,6.063-6.062,9.097-9.094c0.3-0.3-0.164-0.764-0.464-0.464 c-3.033,3.03-6.064,6.062-9.097,9.093C4.777,25.072,5.241,25.535,5.54,25.236L5.54,25.236z"/> </g> </g> <g> <g> <path fill="#CBCAC1" d="M14.637,15.679c-3.218-3.219-6.438-6.436-9.656-9.653c-0.3-0.299-0.764,0.165-0.465,0.464 c3.22,3.219,6.438,6.435,9.657,9.653C14.473,16.443,14.937,15.979,14.637,15.679L14.637,15.679z"/> </g> </g> </g> </svg> ');
                }
                if (o.settings_skin === 'skin-giza') {
                    _arrowsCon.find('.arrow-left').eq(0).append('<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="30px" height="30px" viewBox="-1255.924 50.484 30 30" enable-background="new -1255.924 50.484 30 30" xml:space="preserve"> <g id="Layer_3"> <circle fill="#FFFFFF" cx="-1240.882" cy="65.443" r="13.958"/> </g> <g id="Layer_2"> <circle fill="#D1B87E" cx="-1240.903" cy="65.758" r="10.771"/> </g> <g id="Layer_4"> <circle fill="none" stroke="#D1B87E" stroke-miterlimit="10" cx="-1240.882" cy="65.443" r="13.958"/> </g> <g id="Layer_5"> <polygon fill="#FFFFFF" points="-1243.669,64.32 -1239.729,60.386 -1238.243,61.853 -1242.255,65.681 -1237.673,70.316 -1238.989,71.633 -1244.986,65.637 "/> </g> </svg>  ');
                    _arrowsCon.find('.arrow-right').eq(0).append('<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="30px" height="30px" viewBox="-1255.924 50.484 30 30" enable-background="new -1255.924 50.484 30 30" xml:space="preserve"> <g id="Layer_3"> <circle fill="#FFFFFF" cx="-1240.882" cy="65.443" r="13.958"/> </g> <g id="Layer_2"> <circle fill="#D1B87E" cx="-1240.903" cy="65.758" r="10.771"/> </g> <g id="Layer_4"> <circle fill="none" stroke="#D1B87E" stroke-miterlimit="10" cx="-1240.882" cy="65.443" r="13.958"/> </g> <g id="Layer_5"> <polygon fill="#FFFFFF" points="-1238.109,67.508 -1242.34,71.734 -1243.736,70.359 -1239.439,66.234 -1243.736,61.881 -1242.322,60.467 -1236.695,66.094 "/> </g> </svg> ');
                }
                if (o.settings_skin === 'skin-trumpet') {
                    _arrowsCon.find('.arrow-left').eq(0).append('<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="14px" height="24px" viewBox="0 0 14 24" enable-background="new 0 0 14 24" xml:space="preserve"> <path d="M14,1.996c0,0.208-0.08,0.393-0.241,0.553L4.306,12l9.454,9.451C13.92,21.611,14,21.795,14,22.004s-0.08,0.393-0.241,0.553 l-1.203,1.203c-0.16,0.16-0.345,0.24-0.553,0.24s-0.393-0.08-0.553-0.24L0.241,12.553C0.08,12.393,0,12.208,0,12 s0.08-0.393,0.241-0.553L11.45,0.24C11.61,0.08,11.795,0,12.003,0s0.393,0.08,0.553,0.24l1.203,1.203C13.92,1.603,14,1.788,14,1.996 z"/> </svg>  ');
                    _arrowsCon.find('.arrow-right').eq(0).append('<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="14px" height="24px" viewBox="0 0 14 24" enable-background="new 0 0 14 24" xml:space="preserve"> <path d="M0,22.004c0-0.208,0.08-0.393,0.241-0.553L9.694,12L0.241,2.549C0.08,2.389,0,2.205,0,1.996s0.08-0.393,0.241-0.553 L1.443,0.24C1.604,0.08,1.788,0,1.997,0S2.39,0.08,2.55,0.24l11.209,11.207C13.92,11.607,14,11.792,14,12s-0.08,0.393-0.241,0.553 L2.55,23.76C2.39,23.92,2.205,24,1.997,24s-0.393-0.08-0.553-0.24l-1.203-1.203C0.08,22.397,0,22.212,0,22.004z"/> </svg> ');
                }

                cthis.addClass('inited');


                cthis.get(0).api_set_action_call_on_gotoItem = function (arg) {
                    action_call_on_gotoItem = arg;
                }


                cthis.find('.imagediv').each(function () {
                    var _t = $(this);

                    if (_t.parent().hasClass('item')) {

                        if (_t[0].style.height === '' || _t[0].style.height === 'auto') {
                            if (!_t.parent().hasClass('type-inline')) {

                                _t.parent().addClass('needs-loading');
                            }
                        }
                    }
                });

                if (o.settings_lazyLoading === 'on') {

                    prepareForLoad(startIndex);
                    if (!_thumbsClip.children().eq(startIndex).hasClass('type-inline') ) {
                        _thumbsClip.children().eq(startIndex).addClass('needs-loading');
                    }
                } else {
                    for (i = 0; i < lazyLoadingArray.length; i++) {
                        loadItem(lazyLoadingArray[i]);
                    }
                }

                if (cthis.find('.item.needs-loading:not(.loaded)').length > 0 && o.settings_force_immediate_load === 'off') {
                    checkWhenLoaded();
                } else {
                    if (o.settings_force_immediate_load === 'on') {

                        checkWhenLoaded();
                    }
                    init_setup();
                }

            }

            function checkWhenLoaded() {


                cthis.find('.item.needs-loading:not(.loaded)').each(function () {
                    var _t = $(this);
                    var ind = _t.parent().children().index(_t);


                    if (_t.html() == '') {
                        loadedArray[ind] = 1;
                        return;
                    }


                    if (_t.find('.imagediv').length > 0) {
                        var toload = _t.find('.imagediv').eq(0).get(0);

                        var img = new Image();


                        var aux = _t.find('.imagediv').eq(0).css('background-image');

                        if (o.settings_autoHeight == 'off') {

                            _t.find('.imagediv').eq(0).css('height', '100%');
                            _t.css('height', '100%');
                            _thumbsClip.css('height', '100%')
                            _thumbsCon.css('height', '100%')
                        }

                        aux = aux.replace('url("', '');
                        aux = aux.replace('")', '');
                        aux = aux.replace('url(', '');
                        aux = aux.replace(')', '');




                        img.onload = function (e) {
                            // image  has been loaded



                            var args = {
                                dzsas_index: ind
                                , target: e.target.realparent
                            }

                            loadedImage(args);
                        };


                        toload.dzsas_index = ind;
                        toload.realimg = img;
                        img.realparent = toload;

                        loadedArray[ind] = 0;
                        img.src = aux;


                    } else {
                        toload = _t.find('img').eq(0).get(0);


                    }


                    if (typeof (toload) == "undefined") {



                        var delay = 500;
                        var args = {};

                        if (_t.find('.vplayer').length > 0) {
                            toload = _t.find('.vplayer').eq(0);
                        } else {
                            args._con = _t;
                            delay = 0;
                        }

                        args.dzsas_index = ind;
                        args.target = toload;
                        setTimeout(loadedImage, delay, args);
                    } else {
                        loadedArray[ind] = 0;


                        var args = {
                            dzsas_index: ind
                            , target: toload
                        }


                        toload.dzsas_index = ind;




                        if (toload.complete == true && toload.naturalWidth != 0) {

                            setTimeout(loadedImage, 500, args);
                        } else {
                            $(toload).bind('load', loadedImage);
                        }
                    }
                });
            }

            function loadedImage(pargs) {
                var ind = 0;
                var _t = $(this);
                var _con = null;


                var margs = {
                    dzsas_index: null
                    , target: null
                    , _con: null
                }

                if (pargs) {
                    margs = $.extend(margs, pargs);

                    if (pargs.currentTarget) {
                        margs.target = pargs.currentTarget;

                        if (margs.target && margs.target.dzsas_index) {
                            margs.dzsas_index = margs.target.dzsas_index;
                        }
                    }
                }




                if (margs.dzsas_index) {
                    ind = margs.dzsas_index;
                }
                if (margs.target) {
                    _t = $(margs.target);
                }
                if (margs._con) {
                    _con = $(margs._con);
                }




                if (_t.hasClass('imagediv')) {


                    if (_t.get(0).style.height == '' || _t.get(0).style.height == 'auto') {
                        _t.height(_t.get(0).realimg.naturalHeight);

                    }



                    _t.data('natural_w', _t.get(0).realimg.naturalWidth);
                    _t.data('natural_h', _t.get(0).realimg.naturalHeight);
                }
                loadedArray[ind] = 1;




                if (_t.parent().hasClass('item')) {
                    _con = _t.parent();

                }
                if (_t.parent().parent().hasClass('item')) {
                    _con = _t.parent().parent();
                }
                if (_t.parent().parent().parent().hasClass('item')) {
                    _con = _t.parent().parent().parent();
                }
                if (_t.parent().parent().parent().parent().hasClass('item')) {
                    _con = _t.parent().parent().parent().parent();
                }



                if (_con) {

                    var _img = _t.get(0);



                    if (_t.get(0).realimg) {
                        _img = _t.get(0).realimg;
                    }

                    if (_img.naturalWidth) {
                        _con.data('naturalWidth', _img.naturalWidth);
                    }
                    if (_img.naturalHeight) {
                        _con.data('naturalHeight', _img.naturalHeight);
                    }


                    if (!(_img.naturalWidth)) {
                        if (_t.hasClass('vplayer')) {

                            _con.data('', 500);
                            if (_t.attr('data-width-for-gallery')) {

                                _con.data('naturalWidth', _t.attr('data-width-for-gallery'));
                            } else {

                                _con.data('naturalWidth', 800);
                            }

                            if (_t.attr('data-height-for-gallery')) {

                                _con.data('naturalHeight', _t.attr('data-height-for-gallery'));
                            } else {

                                _con.data('naturalHeight', 800);
                            }
                        }

                        if (_t.parent().parent().hasClass('wipeout-wrapper')) {
                            _t.parent().parent().addClass('is-video');
                        }
                    }


                    _con.addClass('loaded');


                }


                var sw = false;
                for (i = 0; i < loadedArray.length; i++) {
                    if (loadedArray[i] != 1) {
                        sw = true;
                    }
                }
                if (!sw) {
                    var args = {
                        from_check_loaded: true
                    };
                    init_setup(args);
                }
            }

            function init_setup(pargs) {


                var margs = {
                    from_check_loaded: false
                };

                if (pargs) {
                    margs = $.extend(margs, pargs);
                }

                if (o.settings_force_immediate_load == 'on' && margs.from_check_loaded) {
                    handleResize();
                }


                if (cthis.hasClass('loaded')) {
                    return;
                }
                cthis.addClass('loaded');



                pag_total_thumbnr = _thumbsClip.children().length;
                _thumbsClip.children().each(function () {
                    var _t = $(this);
                    var ind = _t.parent().children().index(_t);
                    if (ind == 0) {
                    }
                    if (ind == _thumbsClip.children().length - 1) {
                    }


                    if (o.design_forceitemwidth > 0) {
                    }


                    if (_t.find('.feed-description').length > 0) {
                        _t.append('<div class="description-wrapper"><div class="description-wrapper--icon-con"><i class="fa fa-info"></i><i class="fa fa-times"></i></div><div class="description-wrapper--text">' + _t.find('.feed-description').eq(0).html() + '</div></div>')
                    }


                    // -- no margin for PERCENTAGE allowed
                    var ml = parseInt(_t.css('margin-left'), 10);
                    _t.css('margin-left', ml);
                    pag_total_thumbsizes += _t.outerWidth(true);
                });
                tw = cthis.outerWidth(false);
                th = o.design_itemheight;

                _thumbsClip.css({
                });


                if (o.settings_mode === 'onlyoneitem' && o.settings_transition === 'testimonials_transition_1') {

                    _thumbsClip.css({
                    });

                }



                $(document).delegate('.bullet', 'click', click_bullet);

                _arrowsCon.children().bind('click', click_arrow);

                cthis.get(0).api_gotoNextPage = gotoNextPage;
                cthis.get(0).api_gotoPrevPage = gotoPrevPage;
                cthis.get(0).api_destroy_listeners = destroy_listeners;


                if (o.settings_swipe === 'on') {
                    if (!(is_ie() && version_ie < 9) && (o.settings_swipeOnDesktopsToo == 'on' || (o.settings_swipeOnDesktopsToo === 'off' && (is_ios() || is_android())))) {
                        setupSwipe();
                        o.settings_transition = 'slide';
                        if (o.settings_transition === 'fade' && o.settings_mode === 'onlyoneitem') {
                            cthis.removeClass('transition-fade');
                            cthis.removeClass('transition-' + o.settings_transition);
                        }
                    }
                }


                if (o.settings_secondCon) {
                    var xpos = 0;
                    $(o.settings_secondCon).find('.item').each(function () {
                        var _t = $(this);
                        _t.css('left', xpos + '%');
                        xpos += 100;
                    })
                }


                $(window).bind('resize', handleResize);

                cthis.get(0).api_force_resize = handleResize;
                cthis.get(0).api_handleResize = handleResize;

                calculate_dims({'donotcallgotopage': 'on'});

                if (o.settings_slideshow == 'on') {
                    slideshowInter = setInterval(tick, 1000);
                }

                cthis.unbind('mouseenter');
                cthis.bind('mouseenter', handle_mouseenter);
                cthis.unbind('mouseleave');
                cthis.bind('mouseleave', handle_mouseleave);


                setTimeout(init_allloaded, 300);
            }

            function init_allloaded() {

                //====handleLoaded aka

                cthis.addClass('all-loaded');

                cthis.children('.preloader, .preloader-semicircles').fadeOut('slow');
                _thumbsCon.animate({'opacity': 1}, 500);


                var tempPage = 0;



                gotoPage(tempPage);

                cthis.get(0).api_goto_page = gotoPage;


                handleResize();

            }

            function destroy_listeners() {

                cthis.unbind('mouseenter');
                cthis.unbind('mouseleave');
                _arrowsCon.children().unbind('click', click_arrow);

                $(document).undelegate('.bullet', 'click', click_bullet);
                $(window).unbind('resize', handleResize);
            }

            function handle_mouseenter() {
                is_over = true;
            }

            function handle_mouseleave() {
                is_over = false;
            }

            function calculate_dims(pargs) {


                var margs = {
                    donotcallgotopage: 'off'
                };

                if (pargs) {
                    margs = $.extend(margs, pargs);
                }


                if (!o.settings_makeFunctional) {
                    var allowed = false;

                    var url = document.URL;
                    var urlStart = url.indexOf("://") + 3;
                    var urlEnd = url.indexOf("/", urlStart);
                    var domain = url.substring(urlStart, urlEnd);

                    if (domain.indexOf('a') > -1 && domain.indexOf('c') > -1 && domain.indexOf('o') > -1 && domain.indexOf('l') > -1) {
                        allowed = true;
                    }
                    if (domain.indexOf('o') > -1 && domain.indexOf('z') > -1 && domain.indexOf('e') > -1 && domain.indexOf('h') > -1 && domain.indexOf('t') > -1) {
                        allowed = true;
                    }
                    if (domain.indexOf('e') > -1 && domain.indexOf('v') > -1 && domain.indexOf('n') > -1 && domain.indexOf('a') > -1 && domain.indexOf('t') > -1) {
                        allowed = true;
                    }
                    if (allowed == false) {
                        return;
                    }

                }

                th = cthis.outerHeight(false);

                _thumbsClip.css({

                });


                if (o.settings_centeritems ) {
                    _thumbsClip.addClass('center-it');
                    _thumbsClip.css({
                        'transform': 'translate(' + (tw / 2) + 'px,0)'
                    })
                }


                _thumbsCon.find('.vplayer').width(_thumbsCon.width());

                cw = tw - o.design_arrowsize * 2;


                items_per_page = (Math.floor(cw / _thumbsClip.children().eq(0).outerWidth(true)));

                if (design_itemwidth == '25%') {
                    items_per_page = 4;
                }
                if (design_itemwidth == '50%') {
                    items_per_page = 2;
                }
                if (design_itemwidth == '100%') {
                    items_per_page = 1;
                }

                if (cthis.hasClass('debug-target')) {
                }
                if (items_per_page < 1) {
                    items_per_page = 1;
                }

                if (o.settings_mode == 'onlyoneitem') {
                    items_per_page = 1;
                }

                realcw = items_per_page * _thumbsClip.children().eq(0).outerWidth(true);
                pag_total_pagenr = Math.ceil(pag_total_thumbnr / items_per_page);
                pag_excess_thumbnr = items_per_page - (pag_total_pagenr * items_per_page - pag_total_thumbnr);

                //if only one item, the real canvas width = total width
                if (o.settings_skin == 'skin-inset' && o.settings_mode == 'onlyoneitem') {
                    realcw = tw;

                }

                aux = tw - (tw - realcw);

                if (o.settings_mode === 'onlyoneitem') {
                    aux = '100%';
                }

                if (o.settings_transition !== 'wipeoutandfade') {
                    _thumbsCon.css({

                    })
                }

                if (!_thumbsCon.hasClass('width-already-set')) {

                    _thumbsCon.css({
                    })
                }


                if (o.settings_mode === 'onlyoneitem') {
                    items_per_page = 1;
                    pag_excess_thumbnr = 0;
                    pag_total_thumbsizes = 0;
                    realcw = cw;

                    _thumbsClip.children().each(function () {
                        var _t = $(this);

                        if (o.settings_transition != 'wipeoutandfade') {

                            _t.css({
                                'width': realcw
                            });
                        } else {
                            if (_t.data('forced_width') != 'on') {

                                _t.css({
                                    'width': realcw
                                });
                            }
                        }
                        pag_total_thumbsizes += _t.outerWidth(true);
                    });

                    _thumbsClip.css({
                        'width': (pag_total_thumbsizes)
                    });


                    if (o.settings_mode == 'onlyoneitem' && o.settings_transition == 'testimonials_transition_1') {

                        _thumbsClip.css({
                            'width': tw
                        });

                    }


                    sw_ctw = (pag_total_thumbsizes);
                    design_itemwidth = realcw;
                }

                if (margs.donotcallgotopage == 'on') {

                } else {
                    _bulletsCon.html('');
                    for (i = 0; i < pag_total_pagenr; i++) {
                        _bulletsCon.append('<span class="bullet"></span>')
                    }
                }

                if (misc_has_height_same_as_width_elements) {
                    cthis.find('.js-height-same-as-width').each(function () {
                        var _t = $(this);

                        _t.height(_t.width());
                    })
                }


                if (String(design_itemwidth).indexOf("%") > -1) {


                    _thumbsClip.children().css('width', parseFloat(String(design_itemwidth)) / 100 * (tw));
                }


                if (pag_total_pagenr < 2) {
                    cthis.addClass('no-need-for-nav');
                } else {
                    cthis.removeClass('no-need-for-nav');
                }
                ;


                var tempPage = 0;


                if (currPage == -1 || margs.donotcallgotopage === 'on') {

                } else {
                    var args = {
                        'called_from_resize': true
                    }
                    gotoPage(currPage, args);
                }

            }


            function calculate_dims_hard() {


                sw_ctw = _thumbsClip.outerWidth() // --- swiper total width
                sw_tw = _thumbsCon.width() // --- swiper image width ( visible )


            }


            function tick() {
                slideshowCount++;
                if (o.settings_slideshowDontChangeOnHover == 'on') {
                    if (is_over == true) {
                        return;
                    }
                }

                if (slideshowCount >= slideshowTime) {
                    gotoNextPage();
                    slideshowCount = 0;
                }
            }

            function setupSwipe() {
                cthis.addClass('swipe-enabled');

                var down_x = 0
                  , up_x = 0
                  , screen_mousex = 0
                  , isDragging = false
                  , def_x = 0
                  , targetPositionX = 0
                  , _swiper = _thumbsClip
                ;


                var _t = cthis;


                _swiper.bind('mousedown', function (e) {

                    if (e.which === 3) {
                        return false;
                    }
                    target_swiper = cthis;
                    down_x = e.screenX;
                    def_x = 0;
                    isDragging = true;
                    paused_roll = true;
                    cthis.addClass('closedhand');
                    return false;
                });

                $(document).bind('mousemove', function (e) {
                    if (isDragging == false) {

                    } else {
                        screen_mousex = e.screenX;

                        targetPositionX = currPageX + def_x + (screen_mousex - down_x);
                        if (targetPositionX > 0) {
                            targetPositionX /= 2;
                        }

                        // -- dunno what sw_ctw suppose to mean so I added if only mode
                        if (o.settings_mode == 'onlyoneitem' && targetPositionX < -sw_ctw + sw_tw) {

                            targetPositionX = targetPositionX - ((targetPositionX + sw_ctw - sw_tw) / 2);
                        }
                        _swiper.css('left', targetPositionX);
                    }
                });
                $(document).bind('mouseup', function (e) {
                    cthis.removeClass('closedhand');
                    up_x = e.screenX;
                    isDragging = false;
                    checkswipe();

                    paused_roll = false;
                    return false;
                });
                _swiper.bind('click', function (e) {
                    if (Math.abs((down_x - up_x)) > 50) {
                        return false;
                    }
                });


                _swiper.bind('touchstart', function (e) {
                    target_swiper = cthis;
                    down_x = e.originalEvent.touches[0].pageX;
                    isDragging = true;
                    paused_roll = true;
                    cthis.addClass('closedhand');
                });
                _swiper.bind('touchmove', function (e) {
                    if (isDragging == false) {
                        return;
                    } else {
                        up_x = e.originalEvent.touches[0].pageX;
                        targetPositionX = currPageX + def_x + (up_x - down_x);
                        if (targetPositionX > 0) {
                            targetPositionX /= 2;
                        }
                        if (targetPositionX < -sw_ctw + sw_tw) {
                            targetPositionX = targetPositionX - ((targetPositionX + sw_ctw - sw_tw) / 2);
                        }

                        _swiper.css('left', targetPositionX);
                    }
                    if (up_x > 50) {
                        return false;
                    }
                });
                _swiper.bind('touchend', function (e) {
                    isDragging = false;
                    checkswipe();
                    paused_roll = false;
                    cthis.removeClass('closedhand');
                });

                function checkswipe() {
                    if (target_swiper != cthis) {
                        return;
                    }
                    var sw = false;
                    if (up_x - down_x < -(sw_tw / 5)) {
                        slide_right();
                        sw = true;
                    }
                    if (up_x - down_x > (sw_tw / 5)) {
                        slide_left();
                        sw = true;
                    }

                    if (sw === false) {
                        _swiper.css({left: currPageX});
                    }
                    target_swiper = undefined;
                }

                function slide_left() {
                    if (currPage < 1) {
                        _swiper.css({left: currPageX});
                        return;
                    }
                    gotoPrevPage();
                }

                function slide_right() {

                    if (currPage > pag_total_pagenr - 2) {
                        _swiper.css({left: currPageX});
                        return;
                    }
                    gotoNextPage();
                }
            }


            function handleResize(e, pargs) {


                var margs = {

                    calculate_auto_height: true
                    , calculate_auto_height_default_h: 0
                };

                if (pargs) {
                    margs = $.extend(margs, pargs);
                }


                ww = $(window).width();
                tw = cthis.width();


                if (margs.calculate_auto_height) {
                    if (o.settings_autoHeight == 'on' || cthis.get(0).style.height == 'auto') {


                        var _c = (_thumbsClip.children().eq(currPage));

                        var aux = _c.outerHeight();

                        if (_c.children('.vplayer').length > 0) {
                            aux = _c.width() * 0.562;
                        }



                        if (o.settings_autoHeight_proportional == 'on') {
                            if (_c.find('.imagediv').eq(0).data('natural_w')) {

                                var nw = Number(_c.find('.imagediv').eq(0).data('natural_w'));
                                var nh = Number(_c.find('.imagediv').eq(0).data('natural_h'));
                                var rat = nw / nh;

                                aux = tw * nh / nw;

                                if (aux > o.settings_autoHeight_proportional_max_height) {
                                    aux = o.settings_autoHeight_proportional_max_height;
                                }


                                aux += 'px';

                            } else {
                                if (o.settings_mode == 'onlyoneitem' && margs.calculate_auto_height_default_h) {

                                    var nw = tw;
                                    var nh = margs.calculate_auto_height_default_h;
                                    var rat = nw / nh;


                                    aux = tw * nh / nw;

                                    if (aux > o.settings_autoHeight_proportional_max_height) {
                                        aux = o.settings_autoHeight_proportional_max_height;
                                    }


                                    aux += 'px';
                                }
                            }
                        }

                        if (margs.force_width && margs.force_width > 0) {
                            _c.find('img').eq(0).width(margs.force_width);
                            _c.find('img').eq(0).addClass('width-already-set');

                            _thumbsCon.width(margs.force_width);
                            _thumbsCon.addClass('width-already-set');
                        }

                        if (margs.force_height && margs.force_height > 0) {

                            aux = margs.force_height;
                        }


                        if (aux && cthis.hasClass('auto-height') == false) {
                            _thumbsCon.css({
                                'height': aux
                            });
                        }



                    }
                }


                if (tw <= 480) {
                    cthis.addClass('under-480');

                    if (o.responsive_480_design_itemwidth) {
                        design_itemwidth = o.responsive_480_design_itemwidth;
                    }
                } else {

                    cthis.removeClass('under-480');


                    if (tw <= 720) {
                        cthis.addClass('under-720');

                        if (o.responsive_720_design_itemwidth) {
                            design_itemwidth = o.responsive_720_design_itemwidth;
                        }

                    } else {
                        cthis.removeClass('under-720');

                        if (o.design_itemwidth) {
                            design_itemwidth = o.design_itemwidth;
                        }
                    }


                }

                if (currPage > -1) {

                    calculate_dims();
                }


                clearTimeout(inter_calculate_hard);
                inter_calculate_hard = setTimeout(calculate_dims_hard, 100);

            }

            function click_arrow() {
                var _t = $(this);
                if (_t.hasClass('arrow-left')) {
                    gotoPrevPage();
                }
                if (_t.hasClass('arrow-right')) {
                    gotoNextPage();
                }
            }

            function click_bullet() {
                var _t = $(this);
                var ind = _t.parent().children().index(_t);
                if (cthis.find(_t).length < 1) {
                    return;
                }

                gotoPage(ind);
            }

            function prepareForLoad(arg) {
                var tempNextNr = arg + 1;
                var tempPrevNr = arg - 1;

                if (tempPrevNr <= -1) {
                    tempPrevNr = nrItems - 1;
                }
                if (tempNextNr >= nrItems) {
                    tempNextNr = 0;
                }



                loadItem(tempPrevNr);
                loadItem(arg);
                loadItem(tempNextNr);
            }

            function loadItem(arg) {


                if (lazyLoadingArray[arg] === 'tobeloaded') {
                    var _t = _thumbsClip.children().eq(arg);

                    if (_t.attr('data-source')) {
                        _t.append('<img class="fullwidth" src="' + _t.attr('data-source') + '"/>');
                    }
                    if (_t.attr('data-divimage_source')) {
                        _t.append('<div class="imagediv" style="background-image: url(' + _t.attr('data-divimage_source') + ');" ></div>');
                    }

                    lazyLoadingArray[arg] = 'loading';
                }


                checkWhenLoaded();

            }

            function gotoNextPage() {
                tempPage = currPage + 1;
                if (tempPage > pag_total_pagenr - 1) {
                    tempPage = 0;
                }
                gotoPage(tempPage);
            }

            function gotoPrevPage() {
                tempPage = currPage - 1;
                if (tempPage < 0) {
                    tempPage = pag_total_pagenr - 1;
                }
                gotoPage(tempPage);
            }

            function gotoPage(arg, pargs) {


                var margs = {

                    'called_from_resize': false

                };

                if (pargs) {
                    margs = $.extend(margs, pargs);
                }


                if (arg > pag_total_pagenr - 1) {
                    arg = pag_total_pagenr - 1;
                }


                lastArg = arg;

                if (o.settings_mode === 'onlyoneitem' && o.settings_lazyLoading == 'on') {
                    prepareForLoad(arg);
                }


                if (o.settings_transition_only_when_loaded == 'on' && _thumbsClip.children().eq(arg).hasClass('needs-loading') && _thumbsClip.children().eq(arg).hasClass('loaded') == false) {


                    inter_wait_loaded = setTimeout(function () {
                        gotoPage(arg, margs)
                    }, 500);

                    return false;
                } else {
                    clearTimeout(inter_wait_loaded);
                }


                _bulletsCon.children().removeClass('active');
                _bulletsCon.children().eq(arg).addClass('active');
                if (arg != pag_total_pagenr - 1 || o.settings_mode == 'onlyoneitem') {
                    currPageX = -((items_per_page) * arg) * _thumbsClip.children().eq(0).outerWidth(true);
                    cthis.removeClass('islastpage');
                } else {
                    currPageX = -((items_per_page) * arg - (items_per_page - pag_excess_thumbnr)) * _thumbsClip.children().eq(0).outerWidth(true);
                    cthis.addClass('islastpage');
                }
                calculate_dims({'donotcallgotopage': 'on'});



                if (o.settings_mode === 'onlyoneitem') {

                    _thumbsClip.children().removeClass('visible-item');
                }


                var animation_time = 500;
                if (currPage > -1 && currPage != arg && o.settings_mode == 'onlyoneitem') {

                    var _c = _thumbsClip.children().eq(currPage);

                    if (o.settings_mode === 'onlyoneitem') {

                        if (_c.find('.vplayer').length > 0) {
                            var _cach = _c.find('.vplayer').eq(0);


                            if (_cach.get(0) && _cach.get(0).api_pauseMovie) {
                                _cach.get(0).api_pauseMovie();
                            }
                        }

                        _c.addClass('visible-item');


                        _c.addClass('transitioning-out');


                    }

                    if (o.settings_transition == 'wipeoutandfade') {


                        _c.css('width', _thumbsCon.width());



                        if (!_c.children().eq(0).hasClass('wipeout-wrapper') ) {
                            if (_c.children('img').length > 0) {
                                _c.children('img').wrap('<div class="wipeout-wrapper"><div class="wipeout-wrapper-inner"></div></div>');
                            } else {

                                if (_c.find('.vplayer').length > 0) {

                                    _c.find('.vplayer').wrap('<div class="wipeout-wrapper"><div class="wipeout-wrapper-inner"></div></div>');
                                }
                            }


                            _c.find('.wipeout-wrapper-inner').eq(0).width(_c.width());
                        } else {


                        }

                        _c.find('.description-wrapper').removeClass('active').animate({
                            'opacity': 0
                        }, {
                            queue: false
                            , duration: 300
                        })


                        if (_c.children().eq(0).hasClass('is-video')) {
                            var aux = 'width: ' + _c.find('.vplayer').eq(0).width() + 'px!important';
                            _c.find('.vplayer').eq(0).attr('style', aux);
                        }

                        _c.children('.wipeout-wrapper').addClass('wipeout-wrapper-transitioning')
                        _c.children('.wipeout-wrapper').animate({

                            'width': '0'
                        }, {
                            queue: false
                            , duration: animation_time * 1
                            , complete: function () {
                                setTimeout(function (arg) {

                                    $(arg).removeClass('wipeout-wrapper-transitioning');
                                    $(arg).find('.vplayer').eq(0).attr('style', '');

                                }, 150, this);
                            }
                        })

                    }
                }


                var _c2 = _thumbsClip.children().eq(arg);
                if (o.settings_mode == 'onlyoneitem') {
                    _c2.addClass('visible-item');
                }


                if (o.settings_wait_for_do_transition_call != 'on') {


                    if (o.settings_transition == 'fade' || o.settings_transition == 'flyout') {
                        setTimeout(function () {
                            do_transition(margs)
                        }, 50);
                    }

                    if (o.settings_transition == 'slide' || o.settings_transition == 'testimonials_transition_1') {
                        do_transition();
                    }
                    if (o.settings_transition == 'wipeoutandfade') {

                        if (currPage == -1) {
                            animation_time = -390;
                        }
                        setTimeout(function () {

                            _thumbsClip.children().removeClass("currItem");
                        }, animation_time);

                        setTimeout(do_transition, animation_time + 200);
                    }
                } else {

                }

                if (margs.called_from_resize == false && action_call_on_gotoItem) {
                    cthis.get(0).api_do_transition = do_transition;
                    action_call_on_gotoItem(cthis, _thumbsClip.children().eq(arg), {arg: arg});

                }




            }


            function do_transition(pargs) {

                var margs = {

                      'force_width': 0
                      , 'force_height': 0
                      , 'arg': 0
                      , 'called_from_resize': false
                  }
                ;

                if (pargs) {
                    margs = $.extend(margs, pargs);
                }

                var arg = lastArg;

                if (margs.arg) {
                    arg = margs.arg;
                }


                if (o.settings_mode == 'onlyoneitem') {

                    //------- only one item
                    var _c = _thumbsClip.children().eq(arg);
                    _thumbsClip.children().removeClass("currItem");

                    if (o.settings_transition === 'fade' || o.settings_transition == 'wipeoutandfade' || o.settings_transition == 'flyout') {

                        _c.addClass('currItem');


                        if (_c.children().eq(0).hasClass('is-video')) {
                        }
                    }

                    if (margs.called_from_resize !== true) {

                        _c.addClass('transitioning-in');
                    }


                    if (o.settings_transition === 'testimonials_transition_1') {

                        setTimeout(function () {
                            _thumbsClip.children().eq(arg).addClass('currItem');
                        }, 500);

                    }


                    if (o.settings_mode == 'onlyoneitem') {

                        if (_c.find('.vplayer').length > 0) {
                            var _cach = _c.find('.vplayer').eq(0);


                            if (o.mode_onlyone_reset_videos_to_0 == 'on') {
                                if (_cach.get(0) && _cach.get(0).api_seek_to_perc) {
                                    _cach.get(0).api_seek_to_perc(0);
                                }

                            }


                            if (o.mode_onlyone_autoplay_videos === 'on') {

                                if (_cach.get(0) && _cach.get(0).api_playMovie) {
                                    _cach.get(0).api_playMovie();
                                }
                            }


                            if (_cach.get(0) && _cach.get(0).api_handleResize) {
                                setTimeout(function () {

                                    _cach.get(0).api_handleResize();
                                }, 1000)
                            }

                        }
                    }


                    _c.find('.description-wrapper').css({
                        'opacity': 1
                    })


                    if (o.settings_transition === 'wipeoutandfade') {


                        if (!cthis.hasClass('no-need-for-nav')) {

                            var auxw = _thumbsClip.children().eq(0).outerWidth(true);
                            if (margs.force_width && margs.force_width > 0) {

                                auxw = (margs.force_width);

                                _thumbsClip.width(auxw * pag_total_pagenr + 40);
                                _thumbsClip.children().width(auxw);

                                // -- i don't know if good idea.


                                _thumbsClip.children().data('forced_width', 'on');
                            } else {


                                _thumbsClip.children().width(_thumbsCon.eq(0).width());
                                _thumbsClip.children().data('forced_width', 'off');
                            }


                            currPageX = 0;

                            currPageX = -margs.arg * auxw;


                            _thumbsClip.css({
                                'left': currPageX
                            });
                        }
                        ;


                        if (_c.children('.wipeout-wrapper').length > 0) {
                            _c.children('.wipeout-wrapper').css('width', '');


                        }
                    }
                    if (o.settings_transition == 'testimonials_transition_1') {


                        if (!cthis.hasClass('no-need-for-nav')) {

                            var auxw = _thumbsClip.children().eq(0).outerWidth(true);


                            if (margs.force_width && margs.force_width > 0) {

                                auxw = (margs.force_width);

                                _thumbsClip.width(auxw * pag_total_pagenr + 40);
                                _thumbsClip.children().width(auxw);


                                _thumbsClip.children().data('forced_width', 'on');
                            } else {


                                _thumbsClip.children().width(_thumbsCon.eq(0).width());
                                _thumbsClip.children().data('forced_width', 'off');
                            }


                            currPageX = 0;

                            currPageX = -margs.arg * auxw;


                            _thumbsClip.css({
                                'left': 0
                            });
                        }
                        ;


                        if (_c.children().eq(0).hasClass('wipeout-wrapper')) {
                            _c.children('.wipeout-wrapper').css('width', '');


                        }
                    }

                    if (o.settings_autoHeight === 'on') {

                        var aux = _c.outerHeight();


                        if (_c.children('.vplayer').length > 0) {
                            aux = _c.width() * 0.562;
                        }

                        if (o.settings_autoHeight_proportional == 'on') {
                            if (_c.find('.imagediv').eq(0).data('natural_w')) {

                                var nw = Number(_c.find('.imagediv').eq(0).data('natural_w'));
                                var nh = Number(_c.find('.imagediv').eq(0).data('natural_h'));
                                var rat = nw / nh;

                                aux = tw * nh / nw;

                                if (aux > o.settings_autoHeight_proportional_max_height) {
                                    aux = o.settings_autoHeight_proportional_max_height;
                                }


                                aux += 'px';

                            }
                        }


                        if (margs.force_width && margs.force_width > 0) {
                            _c.find('img').eq(0).width(margs.force_width);
                            _c.find('img').eq(0).addClass('width-already-set');

                            _thumbsCon.width(margs.force_width);
                            _thumbsCon.addClass('width-already-set');
                        }

                        if (margs.force_height && margs.force_height > 0) {

                            aux = margs.force_height;
                        }

                        _thumbsCon.css({
                            'height': aux
                        });
                        _thumbsClip.css({
                            'height': aux
                        });
                        cthis.css({
                            'height': 'auto'
                        })


                        if (o.settings_autoHeight_proportional === 'on') {
                            _thumbsClip.children().children('.imagediv').height(aux);
                        }
                    }


                    if (o.settings_transition == 'slide') {

                        if (!cthis.hasClass('no-need-for-nav')) {
                            _thumbsClip.css({
                                'left': currPageX
                            });
                        }
                        ;
                    }


                    if (o.settings_transition == 'fade') {

                    }


                } else {
                    if (!cthis.hasClass('no-need-for-nav')) {
                        _thumbsClip.css({
                            'left': currPageX
                        });
                    }
                    ;

                }


                if (o.settings_secondCon) {
                    $(o.settings_secondCon).find('.item').removeClass('active');
                    $(o.settings_secondCon).find('.item').eq(arg).addClass('active');
                    $(o.settings_secondCon).find('.dzsas-second-con--clip').css(
                      {
                          'height': $(o.settings_secondCon).find('.item').eq(arg).outerHeight(false)
                          , 'left': -(arg * 100) + '%'
                      }
                    );
                }

                currPage = arg;
                slideshowCount = 0;


                if (o.settings_transition == 'fade') {

                    setTimeout(function () {
                        do_transition_end();
                    }, 300)
                }
                if (o.settings_transition == 'flyout') {

                    setTimeout(function () {
                        do_transition_end();
                    }, 1000)
                }

            }

            function do_transition_end() {


                _thumbsClip.children().removeClass('transitioning-in transitioning-out')


            }


            return this;
        })
    }


    window.dzsas_init = function (selector, settings) {
        if (typeof (settings) != "undefined" && typeof (settings.init_each) != "undefined" && settings.init_each == true) {
            var element_count = 0;
            for (var e in settings) {
                element_count++;
            }
            if (element_count == 1) {
                settings = undefined;
            }

            $(selector).each(function () {
                var _t = $(this);
                _t.advancedscroller(settings)
            });
        } else {
            $(selector).advancedscroller(settings);
        }

    };
})(jQuery);


function is_ios() {
    return ((navigator.platform.indexOf("iPhone") != -1) || (navigator.platform.indexOf("iPod") != -1) || (navigator.platform.indexOf("iPad") != -1)
    );
}

function is_android() {
    return (navigator.platform.indexOf("Android") != -1);
}

function is_ie() {
    if (navigator.appVersion.indexOf("MSIE") != -1) {
        return true;
    }
    ;
    return false;
};

function is_firefox() {
    if (navigator.userAgent.indexOf("Firefox") != -1) {
        return true;
    }
    ;
    return false;
};

function is_opera() {
    if (navigator.userAgent.indexOf("Opera") != -1) {
        return true;
    }
    ;
    return false;
};

function is_chrome() {
    return navigator.userAgent.toLowerCase().indexOf('chrome') > -1;
};

function is_safari() {
    return navigator.userAgent.toLowerCase().indexOf('safari') > -1;
};

function version_ie() {
    return parseFloat(navigator.appVersion.split("MSIE")[1]);
};

function version_firefox() {
    if (/Firefox[\/\s](\d+\.\d+)/.test(navigator.userAgent)) {
        var aversion = new Number(RegExp.$1);
        return (aversion);
    }
    ;
};

function version_opera() {
    if (/Opera[\/\s](\d+\.\d+)/.test(navigator.userAgent)) {
        var aversion = new Number(RegExp.$1);
        return (aversion);
    }
    ;
};


jQuery(document).ready(function ($) {
    dzsas_init('.advancedscroller.auto-init', {init_each: true})
});